package cn.chiship.sdk.third.wechat.core.common;

import cn.chiship.sdk.core.base.constants.BaseConstants;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信小程序
 *
 * @author 李剑
 */
public class WxMiniProgramCommonConstants extends BaseConstants {

    public static final Integer SUCCESS_STATUS = 0;
    private static final String A = "errcode";


    /**
     * Weixin Server服务主机
     */
    public static final String API_WEI_XIN_SERVER_HOST = "https://api.weixin.qq.com/";

    /**
     * 二维码服务主机
     */
    public static final String WEI_XIN_CODE_HOST = "https://mp.weixin.qq.com/";

    /**
     * 获得accessToken
     */
    public static final String GET_TOKEN = "cgi-bin/token";


    /**
     * 获取小程序码，适用于需要的码数量极多的业务场景。
     */
    public static final String GET_QRCODE1 = "wxa/getwxacodeunlimit";


    /**
     * code换取session
     */
    public static final String JSOCODE2SESSION = "sns/jscode2session";

    /**
     * 公共请求头
     *
     * @return 结果
     */
    public static Map<String, String> commonHeaders() {
        Map<String, String> headers = new HashMap<>(2);
        return headers;
    }

    public static String getPubCodeStatusMessage(Integer code) {
        Map<Integer, String> codeStatus = new HashMap<>(2);
        codeStatus.put(-1, "系统繁忙，此时请开发者稍候再试");
        codeStatus.put(0, "请求成功");
        codeStatus.put(40029, "code 无效");
        codeStatus.put(45011, "频率限制，每个用户每分钟100次");
        codeStatus.put(40226, "高风险等级用户，小程序登录拦截 ");
        return codeStatus.get(code);
    }

    public static WeChatCommonResult analysisPubHttpResponse(String responseResult) {
        String msg;
        JSONObject json = JSON.parseObject(responseResult);
        if (json.containsKey(A)) {
            msg = getPubCodeStatusMessage(json.getInteger(A));
            if (SUCCESS_STATUS.equals(json.getInteger(A))) {
                return WeChatCommonResult.ok(json);
            } else {
                return WeChatCommonResult.error(msg == null ? json.getString("errmsg") : msg);
            }
        } else {
            return WeChatCommonResult.ok(json);
        }

    }
}
