package cn.chiship.sdk.third.core.common;


import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;

/**
 * @author lijian
 */
public class ThirdResult extends BaseResult {
    private ThirdResult() {

    }

    private ThirdResult(boolean success, Integer code, String message, Object data) {
        super(success, code, message, data);
    }

    private ThirdResult(Boolean success, BaseResultEnum baseResultEnum, Object data) {
        super(success, baseResultEnum, data);
    }

    public static ThirdResult ok(Object data) {
        return new ThirdResult(Boolean.TRUE, BaseResultEnum.SUCCESS, data);
    }

    public static ThirdResult error(BaseResult baseResult) {
        return new ThirdResult(Boolean.FALSE, baseResult.getCode(), baseResult.getMessage(), baseResult.getData());
    }

    public static ThirdResult error(Object data) {
        return new ThirdResult(Boolean.FALSE, BaseResultEnum.FAILED, data);
    }

    public static ThirdResult error(ThirdResultEnum thirdResultEnum, Object data) {
        return new ThirdResult(Boolean.FALSE, thirdResultEnum.getCode(), thirdResultEnum.getMessage(), data);
    }
}
