package cn.chiship.sdk.third.ali;


import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.common.ThirdResultEnum;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

/**
 * @author lijian
 * 阿里云短信工具
 */
public class AliDySmsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliDySmsUtil.class);
    static final String PRODUCT = "Dysmsapi";
    static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private String aliDySmsSignName;
    private String aliDySmsTemplateCode;
    private BaseConfigModel baseConfigModel;
    private static AliDySmsUtil instance;

    private AliDySmsUtil() {
    }

    public static AliDySmsUtil getInstance() {
        if (instance == null) {
            synchronized (AliDySmsUtil.class) {
                if (instance == null) {
                    instance = new AliDySmsUtil();
                }
            }
        }
        return instance;
    }

    public AliDySmsUtil config() {
        try {
            this.baseConfigModel = new BaseConfigModel(
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("ALI_SMS_ACCESS_KEY_ID"),
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("ALI_SMS_ACCESS_KEY_SECRET")
            );
            if (StringUtil.isNullOrEmpty(this.baseConfigModel.getAppKey()) ||
                    StringUtil.isNullOrEmpty(baseConfigModel.getAppSecret())) {
                throw new SystemErrorException("兄弟,请确保阿里云短信的各个属性[ALI_SMS_ACCESS_KEY_ID、ALI_SMS_ACCESS_KEY_SECRET]配置存在或值不为空!");
            }
        } catch (MissingResourceException e) {
            throw new SystemErrorException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public AliDySmsUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }


    public AliDySmsUtil load(String signName, String templateCode) {
        this.aliDySmsSignName = signName;
        this.aliDySmsTemplateCode = templateCode;
        return this;
    }


    public ThirdResult sendSms(String mobile, Map<String, String> paramsMap) {
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");

            IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", this.baseConfigModel.getAppKey(), this.baseConfigModel.getAppSecret());
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", PRODUCT, DOMAIN);
            IAcsClient acsClient = new DefaultAcsClient(profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setPhoneNumbers(mobile);
            request.setSignName(this.aliDySmsSignName);
            request.setTemplateCode(this.aliDySmsTemplateCode);
            if (null != paramsMap) {
                request.setTemplateParam(JSON.toJSONString(paramsMap));
            }
            SendSmsResponse response = acsClient.getAcsResponse(request);
            LOGGER.info("短信接口返回的数据----------------");
            LOGGER.info("Code={}", response.getCode());
            LOGGER.info("Message={}", response.getMessage());
            LOGGER.info("RequestId={}", response.getRequestId());
            if (response.getCode() != null && ThirdConstants.STRING_OK.equals(response.getCode())) {
                QuerySendDetailsResponse querySendDetailsResponse = querySendDetails(response.getBizId());
                LOGGER.info("短信明细查询接口返回数据----------------");
                LOGGER.info("Code={}", querySendDetailsResponse.getCode());
                LOGGER.info("Message={}", querySendDetailsResponse.getMessage());
                return ThirdResult.ok(null);
            } else {
                return ThirdResult.error(ThirdResultEnum.ERROR_ALI_DY_SMS, response.getMessage());
            }
        } catch (Exception e) {
            LOGGER.error("SmsUtil发生错误:{}", e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException(e));
        }

    }

    public QuerySendDetailsResponse querySendDetails(String bizId) throws ClientException {

        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", this.baseConfigModel.getAppKey(), this.baseConfigModel.getAppSecret());
        DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", PRODUCT, DOMAIN);
        IAcsClient acsClient = new DefaultAcsClient(profile);

        QuerySendDetailsRequest request = new QuerySendDetailsRequest();
        request.setPhoneNumber("15000000000");
        request.setBizId(bizId);
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
        request.setSendDate(ft.format(new Date()));
        request.setPageSize(10L);
        request.setCurrentPage(1L);

        return acsClient.getAcsResponse(request);
    }

    public static void main(String[] args) {
        AliDySmsUtil aliDySmsUtil = AliDySmsUtil.getInstance().config();
        Map<String, String> paramsMap = new HashMap<>(2);
        paramsMap.put("code", "123421");
        aliDySmsUtil.load("智舰工作室", "SMS_147418172");
        LOGGER.info(JSON.toJSONString(aliDySmsUtil.sendSms("18363003321", paramsMap)));
    }
}
