package cn.chiship.sdk.third.wechat.network;


import cn.chiship.sdk.core.exception.ExceptionUtil;

import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.core.common.WeiXinMiniProgramCommonConstants;
import cn.chiship.sdk.third.wechat.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wechat.core.entity.subscribe.Template;
import cn.chiship.sdk.third.wechat.core.util.WxBizDataCrypt;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

/**
 * @author lijian
 */
public class WeiXinMiniProgramServicesUtil {

    private WeiXinConfig weiXinConfig;
    private static WeiXinMiniProgramServicesUtil instance;

    private WeiXinMiniProgramServicesUtil() {
    }

    public static WeiXinMiniProgramServicesUtil getInstance() {
        if (instance == null) {
            synchronized (WeiXinMiniProgramServicesUtil.class) {
                if (instance == null) {
                    instance = new WeiXinMiniProgramServicesUtil();
                }
            }
        }
        return instance;
    }

    public WeiXinMiniProgramServicesUtil config() {
        try {
            this.weiXinConfig = new WeiXinConfig(
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("WEI_XIN_MINI_APP_KEY"),
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("WEI_XIN_MINI_APP_SECRET")
            );
            if (StringUtil.isNullOrEmpty(weiXinConfig.getAppKey()) ||
                    StringUtil.isNullOrEmpty(weiXinConfig.getAppSecret())) {
                throw new SystemErrorException("兄弟,请确保微信小程序的各个属性[WEI_XIN_MINI_APP_KEY、WEI_XIN_MINI_APP_SECRET]配置存在或值不为空!");
            }
        } catch (MissingResourceException e) {
            throw new SystemErrorException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public WeiXinMiniProgramServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    /**
     * 通过code换取网页授权access_token
     *
     * @param code 登录时code
     * @return 结果
     */
    public WeChatCommonResult code2Session(String code) {

        Map<String, String> query = new HashMap<>(7);
        query.put("grant_type", "authorization_code");
        query.put("appid", weiXinConfig.getAppKey());
        query.put("secret", weiXinConfig.getAppSecret());
        query.put("js_code", code);

        try {
            String responseResult = HttpUtils.doGet(
                    WeiXinMiniProgramCommonConstants.WEI_XIN_SERVER_HOST,
                    WeiXinMiniProgramCommonConstants.JSOCODE2SESSION,
                    WeChatCommonConstants.commonHeaders(), query);
            return WeiXinMiniProgramCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 解密开放数据
     *
     * @param encryptedData 包括敏感数据在内的完整用户信息的加密数据
     * @param iv            加密初始向量
     * @param sessionKey    登陆换取的sessionKey
     * @return 结果
     */
    public WeChatCommonResult decryptingOpenData(String encryptedData, String iv, String sessionKey) {
        WxBizDataCrypt wxBizDataCrypt = new WxBizDataCrypt(encryptedData, sessionKey, iv);
        return wxBizDataCrypt.decryptData();
    }

    /**
     * 订阅消息发送
     * 待整理
     *
     * @return 结果
     */
    public WeChatCommonResult messageSubscribeSend(Template template) {
        Map<String, String> query = new HashMap<>(2);
        //getToken();
        WeChatCommonResult weChatCommonResult = null;
        if (!weChatCommonResult.isSuccess()) {
            return weChatCommonResult;
        }
        String token = weChatCommonResult.getData().toString();
        query.put("access_token", token);
        try {
            String body = template.toJSON();
            String responseResult = HttpUtils.doPost(
                    WeChatCommonConstants.API_WEI_XIN_SERVER_HOST,
                    WeChatCommonConstants.MESSAGE_SUBSCRIBE_SEND,
                    WeChatCommonConstants.commonHeaders(),
                    query,
                    body);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    public static void main(String[] args) {
        WeiXinMiniProgramServicesUtil weiXinMiniProgramServicesUtil = WeiXinMiniProgramServicesUtil.getInstance().config();
        //System.out.println(JSONObject.toJSONString(weiXinMiniProgramServicesUtil.code2Session("001aKp200yIkoN1cHd400Za5kK2aKp2A")));
        WeChatCommonResult weChatCommonResult = weiXinMiniProgramServicesUtil.decryptingOpenData(
                "ejWmHoHeKlMTN9gT1cWBwavy9TYV0jP7H4c5UF8ZFAN/tGlS0PH8Duli5x8QTbuTWf+/T72q0OlTUpnK7WiuSaXOzwvWSP77UIpzD0DGz+7inuFW2gRQdLDZkbCihp0Dr1Mn4dsI2tBGmaEX6joPYUT+60+YjlRSVMWGa7InhqdLBkVJqLSPiiGSFAmzEwtGpXV7AYfQq15TPFraEfYvTw==",
                "s0gig3g7Oo+mlseiheoV4g==",
                "S58bmyn2qIkQxfWAXKINJQ=="
        );
        System.out.println(JSON.toJSONString(weChatCommonResult));
    }
}
