package cn.chiship.sdk.third.wechat.core.common;

import cn.chiship.sdk.core.base.constants.BaseConstants;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Admin常量
 *
 * @author 李剑
 */
public class WeChatCommonConstants extends BaseConstants {

    public static final Integer SUCCESS_STATUS = 0;
    private static final String A = "errcode";
    public static final String MENU_CLICK = "click";
    public static final String MENU_VIEW = "view";
    public static final String MENU_MINIPROGRAM = "miniprogram";

    /**
     * 消息类型相关
     */

    /**
     * 文本消息
     */
    public static final String MESSAGE_TEXT = "text";
    /**
     * 图片消息
     */
    public static final String MESSAGE_IMAGE = "image";
    /**
     * 位置消息
     */
    public static final String MESSAGE_LOCATION = "LOCATION";
    /**
     * 事件
     */
    public static final String MESSAGE_EVENT = "event";
    /**
     * 订阅事件
     */
    public static final String MESSAGE_SUBSCRIBE = "subscribe";
    /**
     * 取消订阅事件
     */
    public static final String MESSAGE_UNSUBSCRIBE = "unsubscribe";
    /**
     * 图文消息
     */
    public static final String MESSAGE_NEWS = "news";
    /**
     * 单击事件
     */
    public static final String MESSAGE_CLICK = "CLICK";
    /**
     * 浏览事件
     */
    public static final String MESSAGE_VIEW = "VIEW";
    /**
     * 扫描事件
     */
    public static final String MESSAGE_SCAN = "SCAN";


    /**
     * 新关注欢迎语
     */
    public static final String WELCOME = "您好";


    public static final String API_WEI_XIN_SERVER_HOST = "https://api.weixin.qq.com/";


    public static final String MP_WEI_XIN_SERVER_HOST = "https://mp.weixin.qq.com/";

    public static final String OPEN_WEI_XIN_SERVER_HOST = "https://open.weixin.qq.com/";

    /**
     * 获得accessToken
     */
    public static final String GET_TOKEN = "cgi-bin/token";

    /**
     * 获取用户基本信息
     */
    public static final String GET_USER_INFO = "cgi-bin/user/info";

    /**
     * 设置用户备注名
     */
    public static final String UPDATE_USER_REMARK = "cgi-bin/user/info/updateremark";
    /**
     * 获取用户列表
     */
    public static final String GET_USER_URL = "cgi-bin/user/get";

    /**
     * 创建自定义菜单
     */
    public static final String CREATE_MENU_URL = "cgi-bin/menu/create";

    //标签相关
    /**
     * 创建用户标签
     */
    public static final String CREATE_TAGS = "cgi-bin/tags/create";

    /**
     * 编辑用户标签
     */
    public static final String UPDATE_TAGS = "cgi-bin/tags/update";

    /**
     * 删除用户标签
     */
    public static final String DELETE_TAGS = "cgi-bin/tags/delete";

    /**
     * 获取已创建的标签
     */
    public static final String GET_TAGS = "cgi-bin/tags/get";

    /**
     * 标签下的用户
     */
    public static final String TAG_GET_USER = "cgi-bin/user/tag/get";

    /**
     * 用户绑定标签
     */
    public static final String MEMBER_BATCH_TAGS = "cgi-bin/tags/members/batchtagging";

    /**
     * 取消标签绑定
     */
    public static final String MEMBER_BATCH_UN_TAGS = "cgi-bin/tags/members/batchuntagging";

    //素材相关
    /**
     * 上传图文消息内的图片获取URL
     */
    public static final String ADD_UPLOAD_IMG = "media/uploadimg";

    /**
     * 新增其他类型永久素材
     */
    public static final String ADD_MATERIAL = "cgi-bin/material/add_material";

    /**
     * 获取永久素材
     */
    public static final String GET_MATERIAL = "cgi-bin/material/get_material";

    /**
     * 删除永久素材
     */
    public static final String DEL_MATERIAL = "cgi-bin/material/del_material";

    /**
     * 获取素材总数
     */
    public static final String GET_MATERIAL_COUNT = "cgi-bin/material/get_materialcount";

    /**
     * 素材列表
     */
    public static final String GET_BATCH_MATERIAL = "cgi-bin/material/batchget_material";

    /**
     * 获取二维码ticket
     */
    public static final String GET_QRCODE_TICKET = "cgi-bin/qrcode/create";

    /**
     * 获取二维码
     */
    public static final String CREATE_QRCODE_URL = "cgi-bin/showqrcode";

    /**
     * 模板消息发送
     */
    public static final String MESSAGE_TEMPLATE_SEND = "cgi-bin/message/template/send";

    /**
     * 获取模板列表
     */
    public static final String GET_ALL_PRIVATE_TEMPLATE = "cgi-bin/template/get_all_private_template";

    /**
     * 删除模板
     */
    public static final String DEL_PRIVATE_TEMPLATE = "cgi-bin/template/del_private_template";

    /**
     * 发送客服消息
     */
    public static final String SEND_MESSAGE_URL = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=ACCESS_TOKEN";

    //网页服务相关
    /**
     * 1.用户同意授权 获取code
     */
    public static final String AGREE_URL = OPEN_WEI_XIN_SERVER_HOST + "connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";

    /**
     * 2.通过code换取网页授权access_token
     */
    public static final String EXCHANGE_URL = API_WEI_XIN_SERVER_HOST + "sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";

    /**
     * 刷新access_token
     */
    public static final String REFLASE_URL = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=APPID&grant_type=refresh_token&refresh_token=REFRESH_TOKEN";

    /**
     * 拉取授权用户信息
     */
    public static final String GET_PERSON_URL = "sns/userinfo";


    /**
     * 统一下单接口
     */
    public static final String UNIFIED_ORDER_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";

    /**
     * 订阅消息发送
     */
    public static final String MESSAGE_SUBSCRIBE_SEND = "cgi-bin/message/subscribe/send";

    /*
     * 网页服务URL
     */
    /**
     * 刷新access_token
     */
    public static final String REFLASE_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=APPID&grant_type=refresh_token&refresh_token=REFRESH_TOKEN";
    /**
     * 获取jsapi_jsapi_ticket
     */
    public static final String JSAPI_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";
    /**
     * 获取客服基本信息
     */
    public static final String ONLINEKFLIST_URL = "https://api.weixin.qq.com/cgi-bin/customservice/getonlinekflist?access_token=ACCESS_TOKEN";
    /**
     * 创建会话
     */
    public static final String KFCREAT_URL = "https://api.weixin.qq.com/customservice/kfsession/create?access_token=ACCESS_TOKEN";


    /**
     * 公共请求头
     *
     * @return 结果
     */
    public static Map<String, String> commonHeaders() {
        Map<String, String> headers = new HashMap<>(2);
        return headers;
    }

    public static String getPubCodeStatusMessage(Integer code) {
        Map<Integer, String> codeStatus = new HashMap<>(2);
        codeStatus.put(-1, "系统繁忙，此时请开发者稍候再试");
        codeStatus.put(0, "请求成功");
        codeStatus.put(40001, "获取access_token时AppSecret错误，或者access_token无效。请开发者认真比对AppSecret的正确性，或查看是否正在为恰当的公众号调用接口");
        codeStatus.put(40002, "不合法的凭证类型");
        codeStatus.put(40003, "不合法的OpenID，请开发者确认OpenID（该用户）是否已关注公众号，或是否是其他公众号的OpenID");
        codeStatus.put(40004, "不合法的媒体文件类型");
        codeStatus.put(40005, "不合法的文件类型");
        codeStatus.put(40006, "不合法的文件大小");
        codeStatus.put(40007, "不合法的媒体文件id");
        codeStatus.put(40008, "不合法的消息类型");
        codeStatus.put(40009, "不合法的图片文件大小");
        codeStatus.put(40010, "不合法的语音文件大小");
        codeStatus.put(40011, "不合法的视频文件大小");
        codeStatus.put(40012, "不合法的缩略图文件大小");
        codeStatus.put(40013, "不合法的AppID，请开发者检查AppID的正确性，避免异常字符，注意大小写");
        codeStatus.put(40014, "不合法的access_token，请开发者认真比对access_token的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口");
        codeStatus.put(40015, "不合法的菜单类型");
        codeStatus.put(40016, "不合法的按钮个数");
        codeStatus.put(40017, "不合法的按钮个数");
        codeStatus.put(40018, "不合法的按钮名字长度");
        codeStatus.put(40019, "不合法的按钮KEY长度");
        codeStatus.put(40020, "不合法的按钮URL长度");
        codeStatus.put(40021, "不合法的菜单版本号");
        codeStatus.put(40022, "不合法的子菜单级数");
        codeStatus.put(40023, "不合法的子菜单按钮个数");
        codeStatus.put(40024, "不合法的子菜单按钮类型");
        codeStatus.put(40025, "不合法的子菜单按钮名字长度");
        codeStatus.put(40026, "不合法的子菜单按钮KEY长度");
        codeStatus.put(40027, "不合法的子菜单按钮URL长度");
        codeStatus.put(40028, "不合法的自定义菜单使用用户");
        codeStatus.put(40029, "不合法的oauth_code");
        codeStatus.put(40030, "不合法的refresh_token");
        codeStatus.put(40031, "不合法的openid列表");
        codeStatus.put(40032, "不合法的openid列表长度");
        codeStatus.put(40033, "不合法的请求字符，不能包含xxxx格式的字符");
        codeStatus.put(40035, "不合法的参数");
        codeStatus.put(40038, "不合法的请求格式");
        codeStatus.put(40039, "不合法的URL长度");
        codeStatus.put(40050, "不合法的分组id");
        codeStatus.put(40051, "分组名字不合法");
        codeStatus.put(40054, "子菜单中链接不合法");
        codeStatus.put(40117, "分组名字不合法型");
        codeStatus.put(40118, "media_id大小不合法");
        codeStatus.put(40119, "button类型错误");
        codeStatus.put(40120, "button类型错误");
        codeStatus.put(40121, "不合法的media_id类型");
        codeStatus.put(40132, "微信号不合法");
        codeStatus.put(40137, "不支持的图片格式");
        codeStatus.put(41001, "缺少access_token参数");
        codeStatus.put(41002, "缺少appid参数");
        codeStatus.put(41003, "缺少refresh_token参数");
        codeStatus.put(41004, "缺少secret参数");
        codeStatus.put(41005, "缺少多媒体文件数据");
        codeStatus.put(41006, "缺少media_id参数");
        codeStatus.put(41007, "缺少子菜单数据");
        codeStatus.put(41008, "缺少oauth code");
        codeStatus.put(41009, "缺少openid");
        codeStatus.put(42001, "access_token超时，请检查access_token的有效期，请参考基础支持-获取access_token中，对access_token的详细机制说明");
        codeStatus.put(42002, "refresh_token超时");
        codeStatus.put(42003, "oauth_code超时");
        codeStatus.put(43001, "需要GET请求");
        codeStatus.put(43002, "需要POST请求");
        codeStatus.put(43003, "需要HTTPS请求");
        codeStatus.put(43004, "需要接收者关注");
        codeStatus.put(43005, "需要好友关系");
        codeStatus.put(44001, "多媒体文件为空");
        codeStatus.put(44002, "POST的数据包为空");
        codeStatus.put(44003, "图文消息内容为空");
        codeStatus.put(44004, "文本消息内容为空");
        codeStatus.put(45001, "多媒体文件大小超过限制");
        codeStatus.put(45002, "消息内容超过限制");
        codeStatus.put(45003, "标题字段超过限制");
        codeStatus.put(45004, "描述字段超过限制");
        codeStatus.put(45005, "链接字段超过限制");
        codeStatus.put(45006, "图片链接字段超过限制");
        codeStatus.put(45007, "语音播放时间超过限制");
        codeStatus.put(45008, "图文消息超过限制");
        codeStatus.put(45009, "接口调用超过限制");
        codeStatus.put(45010, "创建菜单个数超过限制");
        codeStatus.put(45015, "回复时间超过限制");
        codeStatus.put(45016, "系统分组，不允许修改");
        codeStatus.put(45017, "分组名字过长");
        codeStatus.put(45018, "分组数量超过上限");
        codeStatus.put(46001, "不存在媒体数据");
        codeStatus.put(46002, "不存在的菜单版本");
        codeStatus.put(46003, "不存在的菜单数据");
        codeStatus.put(46004, "不存在的用户");
        codeStatus.put(47001, "解析JSON/XML内容错误");
        codeStatus.put(48001, "api功能未授权，请确认公众号已获得该接口，可以在公众平台官网-开发者中心页中查看接口权限");
        codeStatus.put(50001, "用户未授权该api");
        codeStatus.put(50002, "用户受限，可能是违规后接口被封禁");
        codeStatus.put(61451, "参数错误(invalid parameter)");
        codeStatus.put(61452, "无效客服账号(invalid kf_account)");
        codeStatus.put(61453, "客服帐号已存在(kf_account exsited)");
        codeStatus.put(61454, "客服帐号名长度超过限制(仅允许10个英文字符，不包括@及@后的公众号的微信号)(invalid kf_acount length)");
        codeStatus.put(61455, "客服帐号名包含非法字符(仅允许英文+数字)(illegal character in kf_account)");
        codeStatus.put(61456, "客服帐号个数超过限制(10个客服账号)(kf_account count exceeded)");
        codeStatus.put(61457, "无效头像文件类型(invalid file type)");
        codeStatus.put(61450, "系统错误(system error)");
        codeStatus.put(61500, "日期格式错误");
        codeStatus.put(61501, "日期范围错误");
        codeStatus.put(9001001, "POST数据参数不合法");
        codeStatus.put(9001002, "远端服务不可用");
        codeStatus.put(9001003, "Ticket不合法");
        codeStatus.put(9001004, "获取摇周边用户信息失败");
        codeStatus.put(9001005, "获取商户信息失败");
        codeStatus.put(9001006, "获取OpenID失败");
        codeStatus.put(9001007, "上传文件缺失");
        codeStatus.put(9001008, "上传素材的文件类型不合法");
        codeStatus.put(9001009, "上传素材的文件尺寸不合法");
        codeStatus.put(9001010, "上传失败");
        codeStatus.put(9001020, "帐号不合法");
        codeStatus.put(9001021, "已有设备激活率低于50%，不能新增设备");
        codeStatus.put(9001022, "设备申请数不合法，必须为大于0的数字");
        codeStatus.put(9001023, "已存在审核中的设备ID申请");
        codeStatus.put(9001024, "一次查询设备ID数量不能超过50");
        codeStatus.put(9001025, "设备ID不合法");
        codeStatus.put(9001026, "页面ID不合法");
        codeStatus.put(9001027, "页面参数不合法");
        codeStatus.put(9001028, "一次删除页面ID数量不能超过10");
        codeStatus.put(9001029, "页面已应用在设备中，请先解除应用关系再删除");
        codeStatus.put(9001030, "一次查询页面ID数量不能超过50");
        codeStatus.put(9001031, "时间区间不合法");
        codeStatus.put(9001032, "保存设备与页面的绑定关系参数错误");
        codeStatus.put(9001033, "门店ID不合法");
        codeStatus.put(9001034, "设备备注信息过长");
        codeStatus.put(9001035, "设备申请参数不合法");
        codeStatus.put(9001036, "查询起始值begin不合法");


        return codeStatus.get(code);
    }

    public static WeChatCommonResult analysisPubHttpResponse(String responseResult) {
        JSONObject json = JSON.parseObject(responseResult);
        if (json.containsKey(A)) {
            String msg = getPubCodeStatusMessage(json.getInteger(A));
            if (SUCCESS_STATUS.equals(json.getInteger(A))) {
                return WeChatCommonResult.ok(json);
            } else {
                return WeChatCommonResult.error(msg == null ? json.getString("errmsg") : msg);
            }
        } else {
            return WeChatCommonResult.ok(json);
        }


    }
}
