package cn.chiship.sdk.third.baidu;


import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.core.common.ThirdResult;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * 百度AIchangliang
 * @author lijian
 */
public class BaiDuAiConstant extends ThirdConstants {
    private static final String ERROR_CODE="error_code";




    public static String getCodeStatusMessage(Integer code){

        Map<String, String> codeStatus = new HashMap<>(2);

        codeStatus.put("SDK102","读取图片文件错误");
        codeStatus.put("0","操作成功");
        codeStatus.put("6","无权限访问该用户数据，创建应用时未勾选相关接口");
        codeStatus.put("216015","模块关闭");
        codeStatus.put("216100","非法参数");
        codeStatus.put("216101","参数数量不够");
        codeStatus.put("216102","业务不支持");
        codeStatus.put("216103","参数太长");
        codeStatus.put("216110","APP ID不存在");
        codeStatus.put("216111","非法用户ID");
        codeStatus.put("216200","空的图片");
        codeStatus.put("216201","图片格式错误");
        codeStatus.put("216202","图片大小错误");
        codeStatus.put("216300","DB错误");
        codeStatus.put("216400","后端系统错误");
        codeStatus.put("216401","内部错误");
        codeStatus.put("216500","未知错误");
        codeStatus.put("216600","身份证的ID格式错误");
        codeStatus.put("216601","身份证的ID和名字不匹配");
        codeStatus.put("216630","识别错误");
        codeStatus.put("216631","识别银行卡错误（通常为检测不到银行卡）");
        codeStatus.put("216632","unknown error");
        codeStatus.put("216633","识别身份证错误（通常为检测不到身份证）");
        codeStatus.put("216634","检测错误");
        codeStatus.put("216635","获取mask图片错误");
        codeStatus.put("222202","图片中没有人脸");
        codeStatus.put("222203","无法解析人脸");

        codeStatus.put("282000","业务逻辑层内部错误");
        codeStatus.put("282001","业务逻辑层后端服务错误");
        codeStatus.put("282100","图片压缩转码错误");

        return codeStatus.get(code.toString());

    }

    public static ThirdResult analysisJson(JSONObject json){
        Boolean success=false;
        String msg=null;
        if (json.has(ERROR_CODE)){
            Integer errorCode=json.getInt(ERROR_CODE);
            if (0 == errorCode){
                success=true;
            }
            msg=getCodeStatusMessage(json.getInt(ERROR_CODE));
            if (StringUtil.isNullOrEmpty(msg)){
                msg="错误码【"+errorCode+"】";
            }

        } else {
            success = true;
        }
        if (Boolean.TRUE.equals(success)){
            return  ThirdResult.ok(json.toString());
        }
        return  ThirdResult.error(msg);

    }

}
