package cn.chiship.sdk.third.ali;


import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyun.dm20151123.models.SingleSendMailRequest;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.MissingResourceException;

/**
 * @author lijian
 * 阿里云短信工具
 */
public class AliMailUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliMailUtil.class);
    static final String PRODUCT = "Dysmsapi";
    static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private String aliDySmsSignName;
    private String aliDySmsTemplateCode;
    private BaseConfigModel baseConfigModel;
    private static AliMailUtil instance;

    private AliMailUtil() {
    }

    public static AliMailUtil getInstance() {
        if (instance == null) {
            synchronized (AliMailUtil.class) {
                if (instance == null) {
                    instance = new AliMailUtil();
                }
            }
        }
        return instance;
    }

    public AliMailUtil config() {
        try {
            this.baseConfigModel = new BaseConfigModel(
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("ALI_SMS_ACCESS_KEY_ID"),
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("ALI_SMS_ACCESS_KEY_SECRET")
            );
            if (StringUtil.isNullOrEmpty(this.baseConfigModel.getAppKey()) ||
                    StringUtil.isNullOrEmpty(baseConfigModel.getAppSecret())) {
                throw new SystemErrorException("兄弟,请确保阿里云短信的各个属性[ALI_SMS_ACCESS_KEY_ID、ALI_SMS_ACCESS_KEY_SECRET]配置存在或值不为空!");
            }
        } catch (MissingResourceException e) {
            throw new SystemErrorException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public AliMailUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }

    public ThirdResult sendEmail() {


        try {
            Config config = new Config()
                    .setAccessKeyId(this.baseConfigModel.getAppKey())
                    .setAccessKeySecret(this.config().baseConfigModel.getAppSecret());
            config.endpoint = "dm.aliyuncs.com";
            com.aliyun.dm20151123.Client client = new com.aliyun.dm20151123.Client(config);
            SingleSendMailRequest singleSendMailRequest = new SingleSendMailRequest()
                    .setAccountName("system@email.chiship.cn")
                    .setAddressType(1)
                    .setToAddress("li1991-hello@163.com")
                    .setSubject("测试")
                    .setHtmlBody("<h2>111</h2>")
                    .setReplyToAddress(true);
            RuntimeOptions runtime = new RuntimeOptions();
            client.singleSendMailWithOptions(singleSendMailRequest, runtime);
            return ThirdResult.ok(null);
        } catch (TeaException error) {
            com.aliyun.teautil.Common.assertAsString(error.message);
            return ThirdResult.error(error.message);
        } catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), _error);
            com.aliyun.teautil.Common.assertAsString(error.message);
            LOGGER.error("AliMailUtil发生错误:{}", _error.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException(_error));
        }
    }

    public static void main(String[] args) {
        AliMailUtil aliDySmsUtil = AliMailUtil.getInstance().config();

        LOGGER.info(JSON.toJSONString(aliDySmsUtil.sendEmail()));
    }
}
