package cn.chiship.sdk.third.wechat.core.util;


import cn.chiship.sdk.core.util.Sha1Util;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * @author lijian
 *
 */
public class WeChatPubUtil {

    /**
     * 微信公众号验签
     * @param token
     * @param signature
     * @param timestamp
     * @param nonce
     * @return
     * @throws NoSuchAlgorithmException
     */
    public static boolean checkSignature(String token,String signature, String timestamp,
                                         String nonce) throws NoSuchAlgorithmException {
        String []arrs=new String[]{token,timestamp,nonce};
        Arrays.sort(arrs);
        StringBuffer buffer=new StringBuffer();
        for (String string : arrs) {
            buffer.append(string);
        }
        String temp= Sha1Util.sha1Encode(buffer.toString());
        return temp.equals(signature);
    }
}
