package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.baidu.singleton.AipFaceClientSingleton;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.model.BaiDuOcrConfigModel;
import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.FaceVerifyRequest;
import com.baidu.aip.face.MatchRequest;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.MissingResourceException;

/**
 * @author lijian
 */
public class BaiDuFaceUtils {
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuFaceUtils INSTANCE;

    private BaiDuFaceUtils() {
    }

    public static BaiDuFaceUtils getInstance() {
        if (INSTANCE == null) {
            synchronized (BaiDuFaceUtils.class) {
                if (INSTANCE == null) {
                    INSTANCE = new BaiDuFaceUtils();
                }
            }
        }
        return INSTANCE;
    }

    public BaiDuFaceUtils config() {
        try {
            BaiDuOcrConfigModel baiDuOcrConfigModel = new BaiDuOcrConfigModel(
                    PropertiesFileUtil.getInstance("chiship-third").get("BAI_DU_AI_API_KEY"),
                    PropertiesFileUtil.getInstance("chiship-third").get("BAI_DU_AI_SECRET_KEY"),
                    PropertiesFileUtil.getInstance("chiship-third").get("BAI_DU_AI_APP_ID")
            );
            if (StringUtil.isNullOrEmpty(baiDuOcrConfigModel.getAppId()) ||
                    StringUtil.isNullOrEmpty(baiDuOcrConfigModel.getAppSecret()) ||
                    StringUtil.isNullOrEmpty(baiDuOcrConfigModel.getAppId())) {
                throw new RuntimeException("兄弟,请确保百度AI的各个属性配置存在或值不为空!");
            }
            config(baiDuOcrConfigModel);
        } catch (MissingResourceException e) {
            throw new RuntimeException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public BaiDuFaceUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel = baiDuOcrConfigModel;
        return this;
    }


    /**
     * 人脸对比
     *
     * @param image1
     * @param isNetwork1
     * @param image2
     * @param isNetwork2
     * @return
     */
    public ThirdResult faceMatch(String image1, Boolean isNetwork1, String image2, Boolean isNetwork2) {
        AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        if (isNetwork1) {
            image1 = ImageUtil.getImgStrByUrl(image1);
        } else {
            image1 = ImageUtil.getImgStrByFile(image1);
        }
        if (isNetwork2) {
            image2 = ImageUtil.getImgStrByUrl(image2);
        } else {
            image2 = ImageUtil.getImgStrByFile(image2);
        }
        MatchRequest req1 = new MatchRequest(image1, "BASE64");
        MatchRequest req2 = new MatchRequest(image2, "BASE64");
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        try {
            JSONObject res = client.match(requests);
            ThirdResult thirdResult = BaiDuAiConstant.analysisJson(res);
            System.out.println(res);
            if (thirdResult.isSuccess()) {

                com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSONObject.parseObject(thirdResult.getData().toString());
                thirdResult.setData(data.getJSONObject("result").getString("score"));
            }
            return thirdResult;
        } catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 在线活体检测
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public ThirdResult faceVerify(String image, Boolean isNetwork) {
        AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        if (isNetwork) {
            image = ImageUtil.getImgStrByUrl(image);
        } else {
            image = ImageUtil.getImgStrByFile(image);
        }
        try {
            FaceVerifyRequest req = new FaceVerifyRequest(image, "BASE64");
            ArrayList<FaceVerifyRequest> list = new ArrayList<FaceVerifyRequest>();
            list.add(req);
            JSONObject res = client.faceverify(list);
            ThirdResult thirdResult = BaiDuAiConstant.analysisJson(res);
            if (thirdResult.isSuccess()) {
                com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSONObject.parseObject(thirdResult.getData().toString());
                thirdResult.setData(data.getJSONObject("result").getString("face_liveness"));
            }
            return thirdResult;
        } catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }


    public static void main(String[] args) {
        BaiDuOcrConfigModel baiDuOcrConfigModel = new BaiDuOcrConfigModel("RogdW5dLLPvUlX7gtSKYLibT", "ZAe3BAmqEg2RprViHHnjveAYMxc8FUOr", "22273864");

        BaiDuFaceUtils baiDuFaceUtils = BaiDuFaceUtils.getInstance().config(baiDuOcrConfigModel);


        //System.out.println(BaiDuAiResultAnalyze.analyzeOcr(baiDuOcrUtils.idCardOcr("C:\\Users\\Administrator\\Desktop\\894fe178fd0cb9f8861ee7e9bd47cec.jpg",true,false)));

        /*身份证*/
       /* System.out.println(BaiDuAiResultAnalyze.analyzeOCR(idCardOcr("C:\\Users\\Administrator\\Desktop\\微信图片_20181228154958.jpg",true,false)));
        System.out.println(idCardOcr("http://localhost:2222/upload/Expect-X-Test/image/player/20181215164415182_561.png",true,true));
        ThirdResult result=BaiDuAiResultAnalyze.analyzeOCR(idCardOcr("https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1545033017653&di=6832897cbf7c366ee3d1ff04530e5fb4&imgtype=0&src=http%3A%2F%2F5b0988e595225.cdn.sohucs.com%2Fimages%2F20181216%2F653d283e52b5491c9cccc74e5d7668ac.jpeg",false,true));
        System.out.println(result);*/

        //文字识别  生僻字无法调用接口
       /* String image = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564136745103&di=ff90e894d13ba91915efa4ad1cd905dd&imgtype=0&src=http%3A%2F%2Fpic.962.net%2Fup%2F2018-5%2F2018527102938219310.jpg";
        String locaImage = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564140117436&di=1e054e18cd1c92713df7f02740dbe9fe&imgtype=0&src=http%3A%2F%2Fphotocdn.sohu.com%2F20130529%2FImg377429405.jpg";
        String rareWord = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564144953580&di=112af7e95e0bf0e9c74ad70d6148adeb&imgtype=0&src=http%3A%2F%2F5b0988e595225.cdn.sohucs.com%2Fimages%2F20181223%2F8fdd34f77a304f0a9d45cf8171b07ce2.jpeg";
        String rareWord2 = "C:\\Users\\mechrevo\\Desktop\\timg3.jpg";
        String webImage = "http://www.grabsun.com/uploads/images/2012/60/2010031614114573.jpg";
        String webImage2 = "http://pic.baike.soso.com/p/20130729/20130729121225-684629691.jpg";
        System.out.println("文字识别"+getSampleWord((JSONObject) characterRecognition(image, true,"word").getData()));
        System.out.println("高精度文字识别"+getSampleWord((JSONObject) characterRecognition(rareWord, true,"highPrecisionWord").getData()));
        System.out.println("高精度文字识别(本地)"+getSampleWord((JSONObject) characterRecognition(rareWord2, false,"highPrecisionWord").getData()));
        System.out.println("生僻字文字识别"+(JSONObject) characterRecognition(image, true,"rareWord").getData());
        System.out.println("文字识别(含位置信息)"+((JSONObject)characterRecognition(rareWord, true, "locationWord").getData()).getJSONArray("words_result"));
        System.out.println("高精度识别生僻字"+((JSONObject)characterRecognition(rareWord, true, "highLocationWord").getData()).getJSONArray("words_result"));
        System.out.println("网络文字识别"+getSampleWord((JSONObject) characterRecognition(webImage, true,"webImage").getData()));
        */

        //银行卡识别
        /*String bankCard = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564203888147&di=c67a2979cf2c5e6167158b0c4a9b7470&imgtype=0&src=http%3A%2F%2Fp0.so.qhmsg.com%2Ft017b682c36e663d84f.jpg";
        String bankCard2 = "C:\\Users\\mechrevo\\Desktop\\timg2.jpg";
        System.out.println("银行卡" + bankCard(bankCard, true).getData());
        System.out.println("银行卡" + bankCard(bankCard2, false).getData());*/

        //驾驶证识别
        /*String drivingLicence = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564205500211&di=152f4a007c43763152bbb58dd770d096&imgtype=0&src=http%3A%2F%2F04.imgmini.eastday.com%2Fmobile%2F20180713%2F20180713195943_b3ef3bb3a55a600cf4e1fa41139358c4_5.jpeg";
        String drivingLicence2="C:\\Users\\mechrevo\\Desktop\\jiashi.jpg";
        System.out.println(drivingLicense(drivingLicence, true));
        System.out.println(drivingLicense(drivingLicence2, false));*/

        //行驶证识别
        /*String vehicleLicense = "https://ss0.bdstatic.com/70cFuHSh_Q1YnxGkpoWK1HF6hhy/it/u=3510470969,2617078641&fm=26&gp=0.jpg";
        String vehicleLicense3 = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564207045279&di=1693757c71dac896d61e88cf31e5cd8b&imgtype=0&src=http%3A%2F%2Fimg1.cache.netease.com%2Fcatchpic%2F3%2F3B%2F3BF7A0FB428A1F07A9B4E3AA5FA815CA.jpg";
        String vehicleLicense2 = "C:\\\\Users\\\\mechrevo\\\\Desktop\\\\xingshi.jpg";
        System.out.println(vehicleLicense(vehicleLicense3, true));
        System.out.println(vehicleLicense(vehicleLicense2, false));*/

        //车牌号识别
      /*  String plateLicense = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564219338842&di=3af499b3afc9638064a75ce861e24050&imgtype=0&src=http%3A%2F%2Fp0.qhimg.com%2Ft01b0f6bc869c6655cb.jpg";
        String plateLicense2 ="C:\\Users\\mechrevo\\Desktop\\chepai.jpg";
        System.out.println("车牌号识别"+plateLicense(plateLicense, true));
        System.out.println("车牌号识别"+plateLicense(plateLicense2, false));*/

        //营业执照识别
        /*String businessLicense = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564219757780&di=4e2feb0e6794ca4e40d323c5d33642fc&imgtype=0&src=http%3A%2F%2Fbaoliao.oeeee.com%2Fupload%2F2%2F2014-0%2F650XH%2F62df72e8-a41a-4386-973b-f8b93e98d8f0.jpg";
        String businessLicense2 ="C:\\Users\\mechrevo\\Desktop\\yingye.jpg";
        System.out.println(businessLicense(businessLicense, true));
        System.out.println(businessLicense(businessLicense2, false));*/
        //通行票据
        /*String receipt = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564220112018&di=d6e0fa60605cafecb483857231c51bc3&imgtype=0&src=http%3A%2F%2Fpic05.997788.com%2Fpic_search%2F00%2F21%2F82%2F17%2Fse21821788.jpg";
        String receipt2 ="C:\\Users\\mechrevo\\Desktop\\tongxing.jpg";
        System.out.println(receipt(receipt, true));
        System.out.println(receipt(receipt2, false));*/

        //火车票
       /* String trainTicket = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564220570131&di=5a0cf8f40d84bf92a00da94d562319ba&imgtype=0&src=http%3A%2F%2Fwww.kfzimg.com%2FG06%2FM00%2FB3%2FF3%2Fp4YBAFsWJjSAVX9rAAElmabQfWE934_n.jpg";
        String trainTicket2 = "C:\\Users\\mechrevo\\Desktop\\huoche.jpg";
        System.out.println(trainTicket(trainTicket, true));
        System.out.println(trainTicket(trainTicket2, false));*/

        //出租车
        /*String taxiReceipt = "https://ss0.bdstatic.com/70cFvHSh_Q1YnxGkpoWK1HF6hhy/it/u=3286190998,3577867542&fm=26&gp=0.jpg";
        String taxiReceipt2 ="C:\\Users\\mechrevo\\Desktop\\chuzu.jpg";
        System.out.println(taxiReceipt(taxiReceipt, true));
        System.out.println(taxiReceipt(taxiReceipt2, false));*/

        //表格文字识别同步
        String form = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564221438521&di=79be98b999d4ea989a92106b94e70dc6&imgtype=0&src=http%3A%2F%2Fimg.9553.com%2Fupload%2F2014%2F3%2F21%2F2014032155052157.jpg";
        String form2 = "C:\\Users\\mechrevo\\Desktop\\biaoge.jpg";
       /* System.out.println(form(form, true));
        System.out.println(form(form2, false));*/

        /*JSONArray result = ((JSONObject) tableRecognitionAsync(form2, false).getData()).getJSONArray("result");
        JSONObject json = (JSONObject)result.get(0);
        String requestId = json.getString("request_id");
        System.out.println(requestId);*/
        //该方法会返回一个解析状态 需判断状态
        /*System.out.println(tableResultGet("16893148_1086361"));*/
        //该方法为封装好的轮询方法 方法参数为文件路径,等待时间
        /*System.out.println(tableRecognizeToJson(form, true));
        System.out.println(tableRecognizeToJson(form2, false));*/

        //增值税发票
       /* String vatInvoice="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564224726079&di=040feff77d811394b0f66f3e9885772c&imgtype=0&src=http%3A%2F%2Fimg.alicdn.com%2Fimgextra%2Fi4%2F653300302%2FTB2Ak4wipXXXXaiXpXXXXXXXXXX_%2521%2521653300302.jpg";
        String vatInvoice2="C:\\Users\\mechrevo\\Desktop\\zengzhi.jpg";
        System.out.println(vatInvoice(vatInvoice, true));
        System.out.println(vatInvoice(vatInvoice2, false));*/

        //二维码 不能调用 需要合作咨询
       /*String qrcode = "https://ss0.bdstatic.com/70cFuHSh_Q1YnxGkpoWK1HF6hhy/it/u=607519565,2848664099&fm=26&gp=0.jpg";
        String qrcode2 ="C:\\Users\\mechrevo\\Desktop\\erwei.jpg";
        System.out.println(qrcode(qrcode, true));
        System.out.println(qrcode(qrcode2, false));*/

        //数字识别
    /*    String numbers = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564225757348&di=2274dbfc0425166cc35a253221424cf1&imgtype=0&src=http%3A%2F%2Ff.hiphotos.baidu.com%2Fzhidao%2Fpic%2Fitem%2F0eb30f2442a7d9336d8e930daf4bd11373f001ad.jpg";
        String numbers2 = "C:\\Users\\mechrevo\\Desktop\\kuaidi.jpg";
        System.out.println(numbers(numbers, true));
        System.out.println(numbers(numbers2, false));*/

        //识别
        /*String lottery = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226149210&di=e7a91626902ab948c549e7e8b0866f50&imgtype=0&src=http%3A%2F%2Fwww.hinews.cn%2Fpic%2F0%2F17%2F04%2F99%2F17049949_520811.jpg";
        String lottery2 = "C:\\Users\\mechrevo\\Desktop\\caipiao.jpg";
        System.out.println(lottery(lottery, true));
        System.out.println(lottery(lottery2, false));*/

        //护照
        /*String passport ="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226314274&di=580271803bba034724452fd6f240498c&imgtype=0&src=http%3A%2F%2Fresources.csi.com.cn%2FuploadFile%2Fa798ed73-6716-49f8-9549-675f4bec58d6.jpg";
        String passport2 ="C:\\Users\\mechrevo\\Desktop\\huzhao.jpg";
        System.out.println(passport(passport, true));
        System.out.println(passport(passport2, false));*/

       /* String businessCard ="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226625151&di=2a78632be84fdef6fa8c6687cf0541ad&imgtype=0&src=http%3A%2F%2Fpic26.nipic.com%2F20130124%2F7074791_213018367135_2.jpg";
        String businessCard2="C:\\Users\\mechrevo\\Desktop\\mingpian.jpg";
        System.out.println(businessCard(businessCard, true));
        System.out.println(businessCard(businessCard2, false));*/

      /* String handwriting ="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226992137&di=88353fc33509dcce80dd693f630fc650&imgtype=0&src=http%3A%2F%2Fb-ssl.duitang.com%2Fuploads%2Fitem%2F201803%2F23%2F20180323225334_seiob.jpg";
        String handwriting2 ="C:\\Users\\mechrevo\\Desktop\\shou.jpg";
        System.out.println(handwriting(handwriting, true));
        System.out.println(handwriting(handwriting2, false));*/
    }
}





