/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wechat.network;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.core.common.WeiXinMiniProgramCommonConstants;
import cn.chiship.sdk.third.wechat.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wechat.core.util.WXBizDataCrypt;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.MissingResourceException;

public class WeiXinMiniProgramServicesUtil {
    private WeiXinConfig weiXinConfig;
    private static WeiXinMiniProgramServicesUtil INSTANCE;

    private WeiXinMiniProgramServicesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WeiXinMiniProgramServicesUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<WeiXinMiniProgramServicesUtil> clazz = WeiXinMiniProgramServicesUtil.class;
        synchronized (WeiXinMiniProgramServicesUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WeiXinMiniProgramServicesUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public WeiXinMiniProgramServicesUtil config() {
        try {
            WeiXinConfig baseConfigModel = new WeiXinConfig(PropertiesFileUtil.getInstance((String)"chiship-third").get("WEI_XIN_MINI_APP_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("WEI_XIN_MINI_APP_SECRET"));
            if (StringUtil.isNullOrEmpty((String)baseConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)baseConfigModel.getAppSecret())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7684\u5404\u4e2a\u5c5e\u6027[WEI_XIN_MINI_APP_KEY\u3001WEI_XIN_MINI_APP_SECRET]\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(baseConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public WeiXinMiniProgramServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    public WeChatCommonResult code2Session(String code) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("grant_type", "authorization_code");
        query.put("appid", this.weiXinConfig.getAppKey());
        query.put("secret", this.weiXinConfig.getAppSecret());
        query.put("js_code", code);
        try {
            String responseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"sns/jscode2session", WeChatCommonConstants.commonHeaders(), query);
            return WeiXinMiniProgramCommonConstants.analysisPubHttpResponse(responseResult);
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult decryptingOpenData(String encryptedData, String iv, String sessionKey) {
        WXBizDataCrypt WXBizDataCrypt2 = new WXBizDataCrypt(encryptedData, sessionKey, iv);
        return WXBizDataCrypt2.decryptData();
    }

    public static void main(String[] args) {
        WeiXinMiniProgramServicesUtil weiXinMiniProgramServicesUtil = WeiXinMiniProgramServicesUtil.getInstance().config();
        WeChatCommonResult weChatCommonResult = weiXinMiniProgramServicesUtil.decryptingOpenData("ejWmHoHeKlMTN9gT1cWBwavy9TYV0jP7H4c5UF8ZFAN/tGlS0PH8Duli5x8QTbuTWf+/T72q0OlTUpnK7WiuSaXOzwvWSP77UIpzD0DGz+7inuFW2gRQdLDZkbCihp0Dr1Mn4dsI2tBGmaEX6joPYUT+60+YjlRSVMWGa7InhqdLBkVJqLSPiiGSFAmzEwtGpXV7AYfQq15TPFraEfYvTw==", "s0gig3g7Oo+mlseiheoV4g==", "S58bmyn2qIkQxfWAXKINJQ==");
        System.out.println(JSONObject.toJSONString((Object)((Object)weChatCommonResult)));
    }
}

