/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.dingtalk;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.common.ThirdResultEnum;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import cn.chiship.sdk.third.dingtalk.DingTalkConstant;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.MissingResourceException;

public class DingTalkServicesUtils {
    private BaseConfigModel baseConfigModel;
    private static DingTalkServicesUtils INSTANCE;

    private DingTalkServicesUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DingTalkServicesUtils getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DingTalkServicesUtils> clazz = DingTalkServicesUtils.class;
        synchronized (DingTalkServicesUtils.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DingTalkServicesUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public DingTalkServicesUtils config() {
        try {
            BaseConfigModel baseConfigModel = new BaseConfigModel(PropertiesFileUtil.getInstance((String)"chiship-third").get("DING_TALK_APP_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("DING_TALK_APP_SECRET"));
            if (StringUtil.isNullOrEmpty((String)baseConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)baseConfigModel.getAppSecret())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u9489\u9489\u7684\u5404\u4e2a\u5c5e\u6027\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(baseConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public DingTalkServicesUtils config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }

    public ThirdResult getToken() {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("appkey", this.baseConfigModel.getAppKey());
        query.put("appsecret", this.baseConfigModel.getAppSecret());
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"gettoken", DingTalkConstant.commonHeaders(), query);
            ThirdResult thirdResult = DingTalkConstant.analysisHttpResponse(responseResult);
            if (thirdResult.isSuccess()) {
                JSONObject jsonObject = (JSONObject)thirdResult.getData();
                return ThirdResult.ok(jsonObject.getString("access_token"));
            }
            return thirdResult;
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public static void main(String[] args) {
        DingTalkServicesUtils dingTalkServicesUtils = DingTalkServicesUtils.getInstance().config();
        System.out.println((Object)dingTalkServicesUtils.getDepartmentList());
    }

    public ThirdResult getDepartmentList() {
        ThirdResult tokenResult = this.getToken();
        if (!tokenResult.isSuccess()) {
            return tokenResult;
        }
        String accessToken = tokenResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", accessToken);
        query.put("fetch_child", String.valueOf(Boolean.TRUE));
        query.put("id", String.valueOf(1));
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"department/list", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(responseResult);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult getUserList(Long departmentId) {
        ThirdResult tokenResult = this.getToken();
        if (!tokenResult.isSuccess()) {
            return tokenResult;
        }
        String accessToken = tokenResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", accessToken);
        query.put("department_id", String.valueOf(departmentId));
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"user/simplelist", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(responseResult);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult getUserListByPage(Long departmentId, Integer page) {
        ThirdResult tokenResult = this.getToken();
        if (!tokenResult.isSuccess()) {
            return tokenResult;
        }
        String accessToken = tokenResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", accessToken);
        query.put("department_id", String.valueOf(departmentId));
        query.put("offset", String.valueOf((page - 1) * 50));
        query.put("size", String.valueOf(50));
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"user/listbypage", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(responseResult);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult getRoleList() {
        ThirdResult tokenResult = this.getToken();
        if (!tokenResult.isSuccess()) {
            return tokenResult;
        }
        String accessToken = tokenResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", accessToken);
        query.put("offset", String.valueOf(0));
        query.put("size", String.valueOf(50));
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"topapi/role/list", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(responseResult);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult getRoleUserList(Long roleId) {
        ThirdResult tokenResult = this.getToken();
        if (!tokenResult.isSuccess()) {
            return tokenResult;
        }
        String accessToken = tokenResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", accessToken);
        query.put("role_id", String.valueOf(roleId));
        query.put("offset", String.valueOf(0));
        query.put("size", String.valueOf(50));
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"topapi/role/simplelist", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(responseResult);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult getReportList(String templateName, Integer day, String userId) {
        ThirdResult tokenResult = this.getToken();
        if (!tokenResult.isSuccess()) {
            return tokenResult;
        }
        String accessToken = tokenResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(2);
        if (null == templateName) {
            templateName = "\u65e5\u62a5";
        }
        if (null == day) {
            day = 1;
        }
        query.put("access_token", accessToken);
        query.put("start_time", String.valueOf(System.currentTimeMillis() - (long)(day * 24 * 60 * 60 * 1000)));
        query.put("end_time", String.valueOf(System.currentTimeMillis()));
        query.put("template_name", templateName);
        if (null != userId) {
            query.put("userid", userId);
        }
        query.put("cursor", String.valueOf(0));
        query.put("size", String.valueOf(50));
        try {
            String responseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"topapi/report/list", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(responseResult);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_DING_TALK, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }
}

