/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.baidu.BaiDuAiConstant;
import cn.chiship.sdk.third.baidu.singleton.AipOcrClientSingleton;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.common.ThirdResultEnum;
import cn.chiship.sdk.third.core.model.BaiDuOcrConfigModel;
import com.baidu.aip.ocr.AipOcr;
import java.util.Base64;
import java.util.HashMap;
import java.util.MissingResourceException;
import org.json.JSONObject;

public class BaiDuOcrUtils {
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuOcrUtils INSTANCE;

    private BaiDuOcrUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BaiDuOcrUtils getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<BaiDuOcrUtils> clazz = BaiDuOcrUtils.class;
        synchronized (BaiDuOcrUtils.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BaiDuOcrUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public BaiDuOcrUtils config() {
        try {
            BaiDuOcrConfigModel baiDuOcrConfigModel = new BaiDuOcrConfigModel(PropertiesFileUtil.getInstance((String)"chiship-third").get("BAI_DU_AI_API_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("BAI_DU_AI_SECRET_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("BAI_DU_AI_APP_ID"));
            if (StringUtil.isNullOrEmpty((String)baiDuOcrConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)baiDuOcrConfigModel.getAppSecret()) || StringUtil.isNullOrEmpty((String)baiDuOcrConfigModel.getAppId())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u767e\u5ea6AI\u7684\u5404\u4e2a\u5c5e\u6027\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(baiDuOcrConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public BaiDuOcrUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel = baiDuOcrConfigModel;
        return this;
    }

    public ThirdResult idCardOcr(String sources, Boolean isFront, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("detect_direction", "true");
        options.put("detect_risk", "false");
        String idCardSide = isFront != false ? "front" : "back";
        try {
            JSONObject res = null;
            sources = isNetwork != false ? ImageUtil.getImgStrByUrl((String)sources) : ImageUtil.getImgStrByFile((String)sources);
            Base64.Decoder decoder = Base64.getDecoder();
            res = client.idcard(decoder.decode(sources), idCardSide, options);
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public ThirdResult idCardOcr(byte[] image, Boolean isFront) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("detect_direction", "true");
        options.put("detect_risk", "false");
        String idCardSide = isFront != false ? "front" : "back";
        try {
            JSONObject res = client.idcard(image, idCardSide, options);
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public ThirdResult characterRecognition(String image, Boolean isNetwork, String type) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        try {
            image = isNetwork != false ? ImageUtil.getImgStrByUrl((String)image) : ImageUtil.getImgStrByFile((String)image);
            Base64.Decoder decoder = Base64.getDecoder();
            JSONObject res = null;
            if ("word".equals(type)) {
                options.put("language_type", "CHN_ENG");
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                options.put("probability", "true");
                res = client.basicGeneral(decoder.decode(image), options);
            }
            if ("highPrecisionWord".equals(type)) {
                options.put("detect_direction", "true");
                options.put("probability", "true");
                res = client.basicAccurateGeneral(decoder.decode(image), options);
            }
            if ("locationWord".equals(type)) {
                options.put("recognize_granularity", "big");
                options.put("language_type", "CHN_ENG");
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                options.put("vertexes_location", "true");
                options.put("probability", "true");
                res = client.general(decoder.decode(image), options);
            }
            if ("highLocationWord".equals(type)) {
                options.put("recognize_granularity", "big");
                options.put("detect_direction", "true");
                options.put("vertexes_location", "true");
                options.put("probability", "true");
                res = client.accurateGeneral(decoder.decode(image), options);
            }
            if ("rareWord".equals(type)) {
                options.put("language_type", "CHN_ENG");
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                options.put("probability", "true");
                res = client.enhancedGeneral(decoder.decode(image), options);
            }
            if ("webImage".equals(type)) {
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                res = client.webImage(decoder.decode(image), options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult bankCard(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("detect_direction", "true");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.bankcard(file, options);
            } else {
                res = client.bankcard(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult drivingLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.drivingLicense(file, options);
            } else {
                res = client.drivingLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult vehicleLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("detect_direction", "true");
        options.put("accuracy", "normal");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.vehicleLicense(file, options);
            } else {
                res = client.vehicleLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult plateLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("multi_detect", "true");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.plateLicense(file, options);
            } else {
                res = client.plateLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult businessLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.businessLicense(file, options);
            } else {
                res = client.businessLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult receipt(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        options.put("probability", "true");
        options.put("accuracy", "normal");
        options.put("detect_direction", "true");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.receipt(file, options);
            } else {
                res = client.receipt(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult trainTicket(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.trainTicket(file, options);
            } else {
                res = client.trainTicket(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult taxiReceipt(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.taxiReceipt(file, options);
            } else {
                res = client.taxiReceipt(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult form(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.form(file, options);
            } else {
                res = client.form(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult tableRecognitionAsync(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.tableRecognitionAsync(file, options);
            } else {
                res = client.tableRecognitionAsync(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult tableResultGet(String requestId) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("result_type", "json");
        try {
            JSONObject res = client.tableResultGet(requestId, options);
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult vatInvoice(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.vatInvoice(file, options);
            } else {
                res = client.vatInvoice(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult qrcode(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.qrcode(file, options);
            } else {
                res = client.qrcode(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult numbers(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        options.put("detect_direction", "true");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.numbers(file, options);
            } else {
                res = client.numbers(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult lottery(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.lottery(file, options);
            } else {
                res = client.lottery(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult passport(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.passport(file, options);
            } else {
                res = client.passport(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult businessCard(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap options = new HashMap(2);
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.businessCard(file, options);
            } else {
                res = client.businessCard(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult handwriting(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.handwriting(file, options);
            } else {
                res = client.handwriting(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public ThirdResult tableRecognizeToJson(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        try {
            JSONObject res;
            if (isNetwork.booleanValue()) {
                byte[] file = ImageUtil.getImgByteByUrl((String)image);
                res = client.tableRecognizeToJson(file, 20000L);
            } else {
                res = client.tableRecognizeToJson(image, 20000L);
            }
            return BaiDuAiConstant.analysisJson(res);
        }
        catch (Exception e) {
            return ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo((Exception)e));
        }
    }

    public static void main(String[] args) {
        BaiDuOcrUtils baiDuOcrUtils = BaiDuOcrUtils.getInstance().config();
        String form = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564221438521&di=79be98b999d4ea989a92106b94e70dc6&imgtype=0&src=http%3A%2F%2Fimg.9553.com%2Fupload%2F2014%2F3%2F21%2F2014032155052157.jpg";
        String form2 = "C:\\Users\\mechrevo\\Desktop\\biaoge.jpg";
    }
}

