/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.ali;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.common.ThirdResultEnum;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliDySmsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliDySmsUtil.class);
    static final String PRODUCT = "Dysmsapi";
    static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private static String aliDySmsSignName;
    private static String aliDySmsTemplateCode;
    private BaseConfigModel baseConfigModel;
    private static AliDySmsUtil INSTANCE;

    private AliDySmsUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliDySmsUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AliDySmsUtil> clazz = AliDySmsUtil.class;
        synchronized (AliDySmsUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AliDySmsUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public AliDySmsUtil config() {
        try {
            BaseConfigModel baseConfigModel = new BaseConfigModel(PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_SMS_ACCESS_KEY_ID"), PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_SMS_ACCESS_KEY_SECRET"));
            if (StringUtil.isNullOrEmpty((String)baseConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)baseConfigModel.getAppSecret())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u963f\u91cc\u4e91\u77ed\u4fe1\u7684\u5404\u4e2a\u5c5e\u6027[ALI_SMS_ACCESS_KEY_ID\u3001ALI_SMS_ACCESS_KEY_SECRET]\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(baseConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public AliDySmsUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }

    public AliDySmsUtil load(String signName, String templateCode) {
        aliDySmsSignName = signName;
        aliDySmsTemplateCode = templateCode;
        return this;
    }

    public ThirdResult sendSms(String mobile, Map<String, String> paramsMap) {
        Boolean flag = false;
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.baseConfigModel.getAppKey(), (String)this.baseConfigModel.getAppSecret());
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setPhoneNumbers(mobile);
            request.setSignName(aliDySmsSignName);
            request.setTemplateCode(aliDySmsTemplateCode);
            if (null != paramsMap) {
                request.setTemplateParam(JSON.toJSONString(paramsMap));
            }
            SendSmsResponse response = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
            LOGGER.info("\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e----------------");
            LOGGER.info("Code=" + response.getCode());
            LOGGER.info("Message=" + response.getMessage());
            LOGGER.info("RequestId=" + response.getRequestId());
            if (response.getCode() != null && "OK".equals(response.getCode())) {
                QuerySendDetailsResponse querySendDetailsResponse = this.querySendDetails(response.getBizId());
                LOGGER.info("\u77ed\u4fe1\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u6570\u636e----------------");
                LOGGER.info("Code=" + querySendDetailsResponse.getCode());
                LOGGER.info("Message=" + querySendDetailsResponse.getMessage());
                return ThirdResult.ok(null);
            }
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_DY_SMS, response.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("SmsUtil\u53d1\u751f\u9519\u8bef:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public QuerySendDetailsResponse querySendDetails(String bizId) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.baseConfigModel.getAppKey(), (String)this.baseConfigModel.getAppSecret());
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)PRODUCT, (String)DOMAIN);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        QuerySendDetailsRequest request = new QuerySendDetailsRequest();
        request.setPhoneNumber("15000000000");
        request.setBizId(bizId);
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
        request.setSendDate(ft.format(new Date()));
        request.setPageSize(Long.valueOf(10L));
        request.setCurrentPage(Long.valueOf(1L));
        QuerySendDetailsResponse querySendDetailsResponse = (QuerySendDetailsResponse)acsClient.getAcsResponse((AcsRequest)request);
        return querySendDetailsResponse;
    }

    public static void main(String[] args) throws ClientException, InterruptedException {
        AliDySmsUtil aliDySmsUtil = AliDySmsUtil.getInstance().config();
        HashMap<String, String> paramsMap = new HashMap<String, String>(2);
        paramsMap.put("code", "123421");
        aliDySmsUtil.load("\u667a\u8230\u5de5\u4f5c\u5ba4", "SMS_147418172");
        LOGGER.info(JSON.toJSONString((Object)((Object)aliDySmsUtil.sendSms("18363003321", paramsMap))));
    }
}

