/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wechat.network;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.RedisUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.common.WeiXinLanguageEnum;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wechat.core.entity.pub.Button;
import cn.chiship.sdk.third.wechat.core.entity.pub.ClickButton;
import cn.chiship.sdk.third.wechat.core.entity.pub.Menu;
import cn.chiship.sdk.third.wechat.core.entity.pub.MiniprogramButton;
import cn.chiship.sdk.third.wechat.core.entity.pub.ViewButton;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.MessageTemplateSend;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.MissingResourceException;

public class WeiXinPubServicesUtil {
    private WeiXinConfig weiXinConfig;
    private static WeiXinPubServicesUtil INSTANCE;

    private WeiXinPubServicesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WeiXinPubServicesUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<WeiXinPubServicesUtil> clazz = WeiXinPubServicesUtil.class;
        synchronized (WeiXinPubServicesUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WeiXinPubServicesUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public WeiXinPubServicesUtil config() {
        try {
            WeiXinConfig baseConfigModel = new WeiXinConfig(PropertiesFileUtil.getInstance((String)"chiship-third").get("WEI_XIN_PUB_APP_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("WEI_XIN_PUB_APP_SECRET"));
            if (StringUtil.isNullOrEmpty((String)baseConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)baseConfigModel.getAppSecret())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u5404\u4e2a\u5c5e\u6027[WEI_XIN_PUB_APP_KEY\u3001WEI_XIN_PUB_APP_SECRET]\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(baseConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public WeiXinPubServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    public WeChatCommonResult getToken() {
        String key = "THIRD:WX_PUB_ACCESS_TOKEN:" + this.weiXinConfig.getAppKey();
        String token = RedisUtil.get((String)key);
        if (!StringUtil.isNullOrEmpty((String)token)) {
            System.out.println("Redis\u83b7\u53d6......");
            return WeChatCommonResult.ok(token);
        }
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("grant_type", "client_credential");
        query.put("appid", this.weiXinConfig.getAppKey());
        query.put("secret", this.weiXinConfig.getAppSecret());
        try {
            String responseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/token", WeChatCommonConstants.commonHeaders(), query);
            WeChatCommonResult result = WeChatCommonConstants.analysisPubHttpResponse(responseResult);
            if (!result.isSuccess()) {
                return result;
            }
            JSONObject dataJson = (JSONObject)result.getData();
            String accessToken = dataJson.getString("access_token");
            String expiresIn = dataJson.getString("expires_in");
            result.setData(accessToken);
            RedisUtil.set((String)key, (String)accessToken, (int)Integer.valueOf(expiresIn));
            System.out.println("\u63a5\u53e3\u83b7\u53d6......");
            return result;
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult getUserInfo(String openId) {
        return this.getUserInfo(openId, WeiXinLanguageEnum.WX_ZH_CN);
    }

    public WeChatCommonResult getUserInfo(String openId, WeiXinLanguageEnum weiXinLanguageEnum) {
        WeChatCommonResult weChatCommonResult = this.getToken();
        if (!weChatCommonResult.isSuccess()) {
            return weChatCommonResult;
        }
        String token = weChatCommonResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("access_token", token);
        query.put("openid", openId);
        query.put("lang", weiXinLanguageEnum.getLang());
        try {
            String responseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/info", WeChatCommonConstants.commonHeaders(), query);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult updateUserRemark(String openId, String remark) {
        WeChatCommonResult weChatCommonResult;
        byte[] bytes = remark.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 30) {
            bytes = Arrays.copyOfRange(bytes, 0, 30);
            remark = new String(bytes);
        }
        if (!(weChatCommonResult = this.getToken()).isSuccess()) {
            return weChatCommonResult;
        }
        String token = weChatCommonResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("access_token", token);
        HashMap<String, String> body = new HashMap<String, String>(7);
        body.put("openid", openId);
        body.put("remark", remark);
        try {
            String responseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/info/updateremark", WeChatCommonConstants.commonHeaders(), query, (String)JSONObject.toJSONString(body));
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult syncUser() {
        return this.syncUser(null);
    }

    public WeChatCommonResult syncUser(String nextOpenId) {
        try {
            WeChatCommonResult weChatCommonResult = this.getToken();
            if (!weChatCommonResult.isSuccess()) {
                return weChatCommonResult;
            }
            String token = weChatCommonResult.getData().toString();
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put("access_token", token);
            query.put("next_openid", nextOpenId);
            String responseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/get", WeChatCommonConstants.commonHeaders(), query);
            WeChatCommonResult result = WeChatCommonConstants.analysisPubHttpResponse(responseResult);
            return result;
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult createMenu(Menu menu) {
        if (menu.getButton().size() > 3) {
            return WeChatCommonResult.error("\u4e00\u7ea7\u6309\u94ae\u4e2a\u6570\u6700\u591a3\u4e2a");
        }
        WeChatCommonResult weChatCommonResult = this.getToken();
        if (!weChatCommonResult.isSuccess()) {
            return weChatCommonResult;
        }
        String token = weChatCommonResult.getData().toString();
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("access_token", token);
        HashMap buttonMap = new HashMap(7);
        ArrayList firstButton = new ArrayList();
        for (Button button : menu.getButton()) {
            HashMap<String, String> menuMap = new HashMap<String, String>();
            menuMap.put("name", button.getName());
            menuMap.put("type", button.getType());
            if ("click".equals(button.getType())) {
                menuMap.put("key", ((ClickButton)button).getKey());
            } else if ("view".equals(button.getType())) {
                menuMap.put("url", ((ViewButton)button).getUrl());
            } else if ("miniprogram".equals(button.getType())) {
                menuMap.put("url", ((MiniprogramButton)button).getUrl());
                menuMap.put("appid", ((MiniprogramButton)button).getAppid());
                menuMap.put("pagepath", ((MiniprogramButton)button).getPagepath());
            }
            if (button.getSub_button() == null) {
                firstButton.add(menuMap);
            } else {
                HashMap<String, Object> secondMap = new HashMap<String, Object>(7);
                secondMap.put("name", button.getName());
                ArrayList secondButton = new ArrayList();
                for (Button SubButton : button.getSub_button()) {
                    HashMap<String, String> second = new HashMap<String, String>(7);
                    second.put("type", SubButton.getType());
                    second.put("name", SubButton.getName());
                    if ("click".equals(SubButton.getType())) {
                        second.put("key", ((ClickButton)SubButton).getKey());
                        secondButton.add(second);
                        continue;
                    }
                    if ("view".equals(SubButton.getType())) {
                        second.put("url", ((ViewButton)SubButton).getUrl());
                        secondButton.add(second);
                        continue;
                    }
                    if (!"miniprogram".equals(SubButton.getType())) continue;
                    second.put("url", ((MiniprogramButton)SubButton).getUrl());
                    second.put("appid", ((MiniprogramButton)SubButton).getAppid());
                    second.put("pagepath", ((MiniprogramButton)SubButton).getPagepath());
                    secondButton.add(second);
                }
                secondMap.put("sub_button", secondButton);
                firstButton.add(secondMap);
            }
            buttonMap.put("button", firstButton);
        }
        System.out.println(JSON.toJSON(buttonMap));
        try {
            String responseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/menu/create", WeChatCommonConstants.commonHeaders(), query, (String)JSONObject.toJSONString(buttonMap));
            WeChatCommonResult result = WeChatCommonConstants.analysisPubHttpResponse(responseResult);
            return result;
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult getQRCodeByForever(String sceneStr) {
        String params = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + sceneStr + "\"}}}";
        return this.getQRCode(params);
    }

    public WeChatCommonResult getQRCodeByTemporary(Integer expireSeconds, String sceneStr) {
        if (expireSeconds > 2592000) {
            expireSeconds = 2592000;
        }
        String params = "{\"expire_seconds\": " + expireSeconds + ", \"action_name\": \"QR_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + sceneStr + "\"}}}";
        return this.getQRCode(params);
    }

    private WeChatCommonResult getQRCode(String params) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        try {
            WeChatCommonResult weChatCommonResult = this.getToken();
            if (!weChatCommonResult.isSuccess()) {
                return weChatCommonResult;
            }
            String token = weChatCommonResult.getData().toString();
            query.put("access_token", token);
            String responseTicketResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/qrcode/create", WeChatCommonConstants.commonHeaders(), query, (String)params);
            WeChatCommonResult ticketResult = WeChatCommonConstants.analysisPubHttpResponse(responseTicketResult);
            if (!ticketResult.isSuccess()) {
                ticketResult.setData("\u83b7\u53d6Ticket\u62a5\u9519\uff0c" + ticketResult.getData());
                return ticketResult;
            }
            String ticket = JSONObject.parseObject((String)JSONObject.toJSONString((Object)ticketResult.getData())).getString("ticket");
            query.put("ticket", URLEncoder.encode(ticket));
            String qrCode = HttpUtils.doGet((String)"https://mp.weixin.qq.com/", (String)"cgi-bin/showqrcode", WeChatCommonConstants.commonHeaders(), query);
            return WeChatCommonResult.ok(qrCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public WeChatCommonResult messageTemplateSend(MessageTemplateSend messageTemplateSend) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        WeChatCommonResult chatCommonResult = this.getToken();
        if (!chatCommonResult.isSuccess()) {
            return chatCommonResult;
        }
        String accessToken = chatCommonResult.getData().toString();
        query.put("access_token", accessToken);
        try {
            String body = JSONObject.toJSONString((Object)messageTemplateSend);
            String responseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/message/template/send", WeChatCommonConstants.commonHeaders(), query, (String)body);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public String getConnectOauth2Url(String redirectUri, String params, Boolean isSilence) {
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect".replace("APPID", this.weiXinConfig.getAppKey()).replace("REDIRECT_URI", URLEncoder.encode(redirectUri)).replace("SCOPE", isSilence != false ? "snsapi_base" : "snsapi_userinfo");
        if (params != null) {
            url = url.replace("STATE", params);
        }
        return url;
    }

    public WeChatCommonResult oauth2AccessToken(String code) {
        try {
            String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code".replace("APPID", this.weiXinConfig.getAppKey()).replace("SECRET", this.weiXinConfig.getAppSecret()).replace("CODE", code);
            String responseResult = HttpUtils.doGet((String)url, (String)"", WeChatCommonConstants.commonHeaders(), null);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public WeChatCommonResult getAccessUserInfo(String token, String openId) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("access_token", token);
        query.put("openid", openId);
        query.put("lang", "zh_CN");
        try {
            String responseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"sns/userinfo", WeChatCommonConstants.commonHeaders(), query);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        }
        catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public static void main(String[] args) {
        WeiXinPubServicesUtil weiXinPubServicesUtil = WeiXinPubServicesUtil.getInstance().config();
        System.out.println(JSON.toJSON((Object)((Object)weiXinPubServicesUtil.getToken())));
    }
}

