/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wechat.core.util;

import cn.chiship.sdk.third.wechat.core.entity.pub.Image;
import cn.chiship.sdk.third.wechat.core.entity.pub.ImageMessage;
import cn.chiship.sdk.third.wechat.core.entity.pub.ImageTextMessage;
import cn.chiship.sdk.third.wechat.core.entity.pub.Item;
import cn.chiship.sdk.third.wechat.core.entity.pub.TextMessage;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.ImageText;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.ImageTextNews;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.ImageTextNewsArticles;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.Text;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.TextNews;
import com.alibaba.fastjson.JSONObject;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubMessageToXml {
    private static final Logger LOGGER = LoggerFactory.getLogger(PubMessageToXml.class);
    private static final Integer TEN = 10;
    private static final Integer ELEVEN = 11;

    public static Map<String, String> xmlToMap(InputStream ins) throws IOException, DocumentException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        SAXReader reader = new SAXReader();
        Document document = reader.read(ins);
        Element root = document.getRootElement();
        List elements = root.elements();
        for (Element element : elements) {
            map.put(element.getName(), element.getText().trim());
        }
        ins.close();
        return map;
    }

    public static String textMessageToXML(TextMessage textMessage) {
        XStream xStream = new XStream();
        xStream.alias("xml", textMessage.getClass());
        return xStream.toXML((Object)textMessage);
    }

    public static String imageMessageToXML(ImageMessage imageMessage) {
        XStream xStream = new XStream();
        xStream.alias("xml", imageMessage.getClass());
        return xStream.toXML((Object)imageMessage);
    }

    public static String imageTextMessageToXML(ImageTextMessage imageTextMessage, Item item) {
        XStream xStream = new XStream();
        xStream.alias("xml", imageTextMessage.getClass());
        xStream.alias("item", item.getClass());
        return xStream.toXML((Object)imageTextMessage);
    }

    public static String initTextMessage(String fromUserName, String toUserName, String content) {
        TextMessage textMessage = new TextMessage();
        textMessage.setFromUserName(toUserName);
        textMessage.setToUserName(fromUserName);
        textMessage.setContent(content);
        textMessage.setMsgType("text");
        textMessage.setCreateTime(System.currentTimeMillis());
        return PubMessageToXml.textMessageToXML(textMessage);
    }

    public static String initImageMessage(String fromUserName, String toUserName, String mediaId) {
        ImageMessage imageMessage = new ImageMessage();
        imageMessage.setFromUserName(toUserName);
        imageMessage.setToUserName(fromUserName);
        imageMessage.setCreateTime(System.currentTimeMillis());
        imageMessage.setMsgType("image");
        Image image = new Image();
        image.setMediaId(mediaId);
        imageMessage.setImage(image);
        return PubMessageToXml.imageMessageToXML(imageMessage);
    }

    public static String initImageTextMessage(String fromUserName, String toUserName, List<Item> item, Integer count) {
        ImageTextMessage imageTextMessage = new ImageTextMessage();
        imageTextMessage.setFromUserName(toUserName);
        imageTextMessage.setToUserName(fromUserName);
        imageTextMessage.setCreateTime(System.currentTimeMillis());
        imageTextMessage.setArticleCount(count);
        imageTextMessage.setMsgType("news");
        if (count < ELEVEN) {
            imageTextMessage.setArticles(item);
            return PubMessageToXml.imageTextMessageToXML(imageTextMessage, new Item());
        }
        ArrayList<Item> item_1 = new ArrayList<Item>();
        for (int i = 0; i < TEN; ++i) {
            item_1.add(item.get(i));
        }
        imageTextMessage.setArticles(item_1);
        return PubMessageToXml.imageTextMessageToXML(imageTextMessage, new Item());
    }

    public static String initImageText(String openId, List<ImageTextNewsArticles> articles) {
        ImageTextNews imageTextNews = new ImageTextNews();
        imageTextNews.setArticles(articles);
        ImageText imageText = new ImageText();
        imageText.setTouser(openId);
        imageText.setMsgtype("news");
        imageText.setNews(imageTextNews);
        return JSONObject.toJSONString((Object)imageText);
    }

    public static String initText(String openId, String content) {
        Text text = new Text();
        text.setContent(content);
        TextNews textNews = new TextNews();
        textNews.setTouser(openId);
        textNews.setMsgtype("text");
        textNews.setText(text);
        return JSONObject.toJSONString((Object)textNews);
    }
}

