/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.baidu.BaiDuAiConstant;
import cn.chiship.sdk.third.baidu.singleton.AipFaceClientSingleton;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.model.BaiDuOcrConfigModel;
import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.FaceVerifyRequest;
import com.baidu.aip.face.MatchRequest;
import java.util.ArrayList;
import java.util.MissingResourceException;
import org.json.JSONObject;

public class BaiDuFaceUtils {
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuFaceUtils INSTANCE;

    private BaiDuFaceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BaiDuFaceUtils getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<BaiDuFaceUtils> clazz = BaiDuFaceUtils.class;
        synchronized (BaiDuFaceUtils.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BaiDuFaceUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public BaiDuFaceUtils config() {
        try {
            BaiDuOcrConfigModel baiDuOcrConfigModel = new BaiDuOcrConfigModel(PropertiesFileUtil.getInstance((String)"chiship-third").get("BAI_DU_AI_API_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("BAI_DU_AI_SECRET_KEY"), PropertiesFileUtil.getInstance((String)"chiship-third").get("BAI_DU_AI_APP_ID"));
            if (StringUtil.isNullOrEmpty((String)baiDuOcrConfigModel.getAppId()) || StringUtil.isNullOrEmpty((String)baiDuOcrConfigModel.getAppSecret()) || StringUtil.isNullOrEmpty((String)baiDuOcrConfigModel.getAppId())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u767e\u5ea6AI\u7684\u5404\u4e2a\u5c5e\u6027\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(baiDuOcrConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public BaiDuFaceUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel = baiDuOcrConfigModel;
        return this;
    }

    public ThirdResult faceMatch(String image1, Boolean isNetwork1, String image2, Boolean isNetwork2) {
        AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        image1 = isNetwork1 != false ? ImageUtil.getImgStrByUrl((String)image1) : ImageUtil.getImgStrByFile((String)image1);
        image2 = isNetwork2 != false ? ImageUtil.getImgStrByUrl((String)image2) : ImageUtil.getImgStrByFile((String)image2);
        MatchRequest req1 = new MatchRequest(image1, "BASE64");
        MatchRequest req2 = new MatchRequest(image2, "BASE64");
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        try {
            JSONObject res = client.match(requests);
            ThirdResult thirdResult = BaiDuAiConstant.analysisJson(res);
            System.out.println(res);
            if (thirdResult.isSuccess()) {
                com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSONObject.parseObject((String)thirdResult.getData().toString());
                thirdResult.setData(data.getJSONObject("result").getString("score"));
            }
            return thirdResult;
        }
        catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public ThirdResult faceVerify(String image, Boolean isNetwork) {
        AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        image = isNetwork != false ? ImageUtil.getImgStrByUrl((String)image) : ImageUtil.getImgStrByFile((String)image);
        try {
            FaceVerifyRequest req = new FaceVerifyRequest(image, "BASE64");
            ArrayList<FaceVerifyRequest> list = new ArrayList<FaceVerifyRequest>();
            list.add(req);
            JSONObject res = client.faceverify(list);
            ThirdResult thirdResult = BaiDuAiConstant.analysisJson(res);
            if (thirdResult.isSuccess()) {
                com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSONObject.parseObject((String)thirdResult.getData().toString());
                thirdResult.setData(data.getJSONObject("result").getString("face_liveness"));
            }
            return thirdResult;
        }
        catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public static void main(String[] args) {
        BaiDuOcrConfigModel baiDuOcrConfigModel = new BaiDuOcrConfigModel("RogdW5dLLPvUlX7gtSKYLibT", "ZAe3BAmqEg2RprViHHnjveAYMxc8FUOr", "22273864");
        BaiDuFaceUtils baiDuFaceUtils = BaiDuFaceUtils.getInstance().config(baiDuOcrConfigModel);
        String form = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564221438521&di=79be98b999d4ea989a92106b94e70dc6&imgtype=0&src=http%3A%2F%2Fimg.9553.com%2Fupload%2F2014%2F3%2F21%2F2014032155052157.jpg";
        String form2 = "C:\\Users\\mechrevo\\Desktop\\biaoge.jpg";
    }
}

