/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.ali;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.common.ThirdResultEnum;
import cn.chiship.sdk.third.core.model.AliOssConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOssUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliOssUtil.class);
    private AliOssConfigModel aliOssConfigModel;
    private static AliOssUtil INSTANCE;

    private AliOssUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliOssUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AliOssUtil> clazz = AliOssUtil.class;
        synchronized (AliOssUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AliOssUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public AliOssUtil config() {
        try {
            AliOssConfigModel emailConfigModel = new AliOssConfigModel(PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_OSS_ACCESS_KEY_ID"), PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_OSS_ACCESS_KEY_SECRET"), PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_OSS_END_PORT"), PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_OSS_BUCK_NAME"), PropertiesFileUtil.getInstance((String)"chiship-third").get("ALI_OSS_ROOT"));
            if (StringUtil.isNullOrEmpty((String)emailConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)emailConfigModel.getAppSecret()) || StringUtil.isNullOrEmpty((String)emailConfigModel.getOssEndPort()) || StringUtil.isNullOrEmpty((String)emailConfigModel.getBuckName()) || StringUtil.isNullOrEmpty((String)emailConfigModel.getRoot())) {
                throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u963f\u91cc\u4e91\u5b58\u50a8\u7684\u5404\u4e2a\u5c5e\u6027[ALI_OSS_ACCESS_KEY_ID\u3001ALI_OSS_ACCESS_KEY_SECRET\u3001ALI_OSS_END_PORT\u3001ALI_OSS_BUCK_NAME\u3001ALI_OSS_ROOT]\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
            this.config(emailConfigModel);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public AliOssUtil config(AliOssConfigModel aliOssConfigModel) {
        this.aliOssConfigModel = aliOssConfigModel;
        return this;
    }

    public ThirdResult upload(String imageName, InputStream in) {
        return this.upload(null, imageName, in);
    }

    public ThirdResult upload(String catalog, String imageName, InputStream in) {
        try {
            String fileUrl;
            OSS client = new OSSClientBuilder().build(this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getAppKey(), this.aliOssConfigModel.getAppSecret());
            if (!StringUtil.isNullOrEmpty((String)catalog)) {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName, in);
            } else {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + imageName, in);
            }
            client.shutdown();
            LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            return ThirdResult.ok(fileUrl);
        }
        catch (OSSException e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }
        catch (ClientException e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public ThirdResult uploadBase64(String imageName, String base64) {
        return this.uploadBase64(null, imageName, base64);
    }

    public ThirdResult uploadBase64(String catalog, String imageName, String base64) {
        try {
            String fileUrl;
            OSS client = new OSSClientBuilder().build(this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getAppKey(), this.aliOssConfigModel.getAppSecret());
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] bytes = decoder.decode(base64);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)((InputStream)inputStream).available());
            if (!StringUtil.isNullOrEmpty((String)catalog)) {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName, (InputStream)inputStream);
            } else {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + imageName, (InputStream)inputStream);
            }
            client.shutdown();
            LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            return ThirdResult.ok(fileUrl);
        }
        catch (OSSException e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }
        catch (ClientException e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public ThirdResult remove(String objectName) {
        ArrayList<String> objectNames = new ArrayList<String>();
        objectNames.add(objectName);
        return this.remove(objectNames);
    }

    public ThirdResult remove(List<String> objectNames) {
        try {
            OSS client = new OSSClientBuilder().build(this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getAppKey(), this.aliOssConfigModel.getAppSecret());
            ArrayList<String> trueObjectNames = new ArrayList<String>();
            for (String objectName : objectNames) {
                trueObjectNames.add(this.aliOssConfigModel.getRoot() + "/" + objectName);
            }
            DeleteObjectsResult deleteObjectsResult = client.deleteObjects(new DeleteObjectsRequest(this.aliOssConfigModel.getBuckName()).withKeys(trueObjectNames));
            List deletedObjects = deleteObjectsResult.getDeletedObjects();
            client.shutdown();
            LOGGER.info("\u6587\u4ef6\u522a\u9664\u6210\u529f");
            return ThirdResult.ok(null);
        }
        catch (OSSException e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }
        catch (ClientException e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error("AliOssUtil\u53d1\u751f\u9519\u8bef:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException((Exception)e));
        }
    }

    public static void main(String[] args) throws Exception {
        AliOssUtil aliOssUtil = AliOssUtil.getInstance().config();
        LOGGER.info(JSON.toJSONString((Object)((Object)aliOssUtil.remove("null/1111.pptx"))));
    }
}

