package cn.chiship.sdk.third.wechat.network;


import cn.chiship.sdk.core.exception.ExceptionUtil;

import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.core.common.WeiXinMiniProgramCommonConstants;
import cn.chiship.sdk.third.wechat.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wechat.core.util.WXBizDataCrypt;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public class WeiXinMiniProgramServicesUtil {

    private WeiXinConfig weiXinConfig;
    private static WeiXinMiniProgramServicesUtil INSTANCE;

    private WeiXinMiniProgramServicesUtil() {
    }

    public static WeiXinMiniProgramServicesUtil getInstance() {
        if (INSTANCE == null) {
            synchronized (WeiXinMiniProgramServicesUtil.class) {
                if (INSTANCE == null) {
                    INSTANCE = new WeiXinMiniProgramServicesUtil();
                }
            }
        }
        return INSTANCE;
    }

    public WeiXinMiniProgramServicesUtil config() {
        try {
            WeiXinConfig baseConfigModel = new WeiXinConfig(
                    PropertiesFileUtil.getInstance("chiship-third").get("WEI_XIN_MINI_APP_KEY"),
                    PropertiesFileUtil.getInstance("chiship-third").get("WEI_XIN_MINI_APP_SECRET")
            );
            if (StringUtil.isNullOrEmpty(baseConfigModel.getAppKey()) ||
                    StringUtil.isNullOrEmpty(baseConfigModel.getAppSecret())) {
                throw new RuntimeException("兄弟,请确保微信小程序的各个属性[WEI_XIN_MINI_APP_KEY、WEI_XIN_MINI_APP_SECRET]配置存在或值不为空!");
            }
            config(baseConfigModel);
        } catch (MissingResourceException e) {
            throw new RuntimeException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public WeiXinMiniProgramServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    /**
     * 通过code换取网页授权access_token
     *
     * @param code 登录时code
     * @return
     */
    public WeChatCommonResult code2Session(String code) {

        Map<String, String> query = new HashMap<>(7);
        query.put("grant_type", "authorization_code");
        query.put("appid", weiXinConfig.getAppKey());
        query.put("secret", weiXinConfig.getAppSecret());
        query.put("js_code", code);

        try {
            String responseResult = HttpUtils.doGet(
                    WeiXinMiniProgramCommonConstants.WEI_XIN_SERVER_HOST,
                    WeiXinMiniProgramCommonConstants.JSOCODE2SESSION,
                    WeChatCommonConstants.commonHeaders(), query);
            return WeiXinMiniProgramCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 解密开放数据
     *
     * @param encryptedData 包括敏感数据在内的完整用户信息的加密数据
     * @param iv            加密初始向量
     * @param sessionKey    登陆换取的sessionKey
     * @return
     */
    public WeChatCommonResult decryptingOpenData(String encryptedData, String iv, String sessionKey) {
        WXBizDataCrypt WXBizDataCrypt = new WXBizDataCrypt(encryptedData, sessionKey, iv);
        return WXBizDataCrypt.decryptData();
    }

    /**
     * 订阅消息发送
     *
     * @return
     */
    /*public WeChatCommonResult messageSubscribeSend(Template template) {
        Map<String, String> query = new HashMap<>(2);
        WeChatCommonResult weChatCommonResult = getToken();
        if (!weChatCommonResult.isSuccess()) {
            return weChatCommonResult;
        }
        String token = weChatCommonResult.getData().toString();
        query.put("access_token", token);
        try {
            String body = template.toJSON();
            String responseResult = HttpUtils.doPost(
                    WeChatCommonConstants.WEI_XIN_SERVER_HOST,
                    WeChatCommonConstants.MESSAGE_SUBSCRIBE_SEND,
                    WeChatCommonConstants.commonHeaders(),
                    query,
                    body);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }*/
    public static void main(String[] args) {
        WeiXinMiniProgramServicesUtil weiXinMiniProgramServicesUtil = WeiXinMiniProgramServicesUtil.getInstance().config();
        //System.out.println(JSONObject.toJSONString(weiXinMiniProgramServicesUtil.code2Session("001aKp200yIkoN1cHd400Za5kK2aKp2A")));
        WeChatCommonResult weChatCommonResult = weiXinMiniProgramServicesUtil.decryptingOpenData(
                "ejWmHoHeKlMTN9gT1cWBwavy9TYV0jP7H4c5UF8ZFAN/tGlS0PH8Duli5x8QTbuTWf+/T72q0OlTUpnK7WiuSaXOzwvWSP77UIpzD0DGz+7inuFW2gRQdLDZkbCihp0Dr1Mn4dsI2tBGmaEX6joPYUT+60+YjlRSVMWGa7InhqdLBkVJqLSPiiGSFAmzEwtGpXV7AYfQq15TPFraEfYvTw==",
                "s0gig3g7Oo+mlseiheoV4g==",
                "S58bmyn2qIkQxfWAXKINJQ=="
        );
        System.out.println(JSONObject.toJSONString(weChatCommonResult));
    }
}
