package cn.chiship.sdk.third.baidu;


import cn.chiship.sdk.third.core.common.ThirdResult;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * 结果分析
 * @author lijian
 */
public class BaiDuAiResultAnalyze {
    public static final String OCR_IDCARD_REAL_NAME="姓名";
    public static final String OCR_IDCARD_REAL_NATION="民族";
    public static final String OCR_IDCARD_ADDRESS="住址";
    public static final String OCR_IDCARD_ID="公民身份号码";
    public static final String OCR_IDCARD_BIRTHDAY="出生";
    public static final String OCR_IDCARD_SEX="性别";
    public static final String OCR_IDCARD_EXPIRATION_DATE="失效日期";
    public static final String OCR_IDCARD_ISSUE_OFFICE="签发机关";
    public static final String OCR_IDCARD_ISSUE_DATE="签发日期";
    public static ThirdResult analyzeOcr(ThirdResult thirdResult){
        Map map=new HashMap(2);
        boolean success=false;
        String message=null;
        try {
            if(thirdResult.isSuccess()){
                JSONObject json=new JSONObject(thirdResult.getData().toString());
                JSONObject wordsResult=json.getJSONObject("words_result");
                if (wordsResult.isNull(OCR_IDCARD_REAL_NAME)){
                    map.put("realName","");
                }else{
                    map.put("realName",wordsResult.getJSONObject(OCR_IDCARD_REAL_NAME).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_REAL_NATION)){
                    map.put("nation","");
                }else{
                    map.put("nation",wordsResult.getJSONObject(OCR_IDCARD_REAL_NATION).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_BIRTHDAY)){
                    map.put("birthday","");
                }else{
                    map.put("birthday",wordsResult.getJSONObject(OCR_IDCARD_BIRTHDAY).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_ADDRESS)){
                    map.put("address","");
                }else{
                    map.put("address",wordsResult.getJSONObject(OCR_IDCARD_ADDRESS).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_ID)){
                    map.put("ID","");
                }else{
                    map.put("ID",wordsResult.getJSONObject(OCR_IDCARD_ID).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_SEX)){
                    map.put("sex","");
                }else{
                    map.put("sex",wordsResult.getJSONObject(OCR_IDCARD_SEX).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_EXPIRATION_DATE)){
                    map.put("expirationDate","");
                }else{
                    map.put("expirationDate",wordsResult.getJSONObject(OCR_IDCARD_EXPIRATION_DATE).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_ISSUE_OFFICE)){
                    map.put("issueOffice","");
                }else{
                    map.put("issueOffice",wordsResult.getJSONObject(OCR_IDCARD_ISSUE_OFFICE).getString("words"));
                }
                if (wordsResult.isNull(OCR_IDCARD_ISSUE_DATE)){
                    map.put("issueDate","");
                }else{
                    map.put("issueDate",wordsResult.getJSONObject(OCR_IDCARD_ISSUE_DATE).getString("words"));
                }
                success=true;
            }else{
                message=thirdResult.getMessage();
            }
        }catch (Exception e){
            message=e.getLocalizedMessage();
        }
        if (success){
            return ThirdResult.ok(map);
        }
        return ThirdResult.error(message);
    }
}
