package cn.chiship.sdk.third.wechat.network;


import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.wechat.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.config.WeiXinConfig;
import cn.chiship.sdk.third.wechat.entity.subscribe.Template;
import cn.chiship.sdk.third.wechat.entity.subscribe.TemplateParam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 微信服务工具类
 *
 * @author lijian
 */
public class WeiXinSubscribeServicesUtils {

    /**
     * 订阅消息发送
     *
     * @return
     */
    public static WeChatCommonResult messageSubscribeSend(WeiXinConfig weiXinConfig, Template template) {
        WeChatCommonResult token = WeiXinPubServicesUtils.getToken(weiXinConfig);
        String accessToken = token.getData().toString();
        Map<String, String> query = new HashMap<>(2);
        query.put("access_token", accessToken);
        try {
            String body = template.toJSON();
            String responseResult = HttpUtils.doPost(WeChatCommonConstants.WEI_XIN_SERVER_HOST, WeChatCommonConstants.MESSAGE_SUBSCRIBE_SEND, WeChatCommonConstants.commonHeaders(), query, body);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    public static void main(String[] args) {
        Template template = new Template();
        template.setTemplate_id("G87hkVVVm9j2I3ofss2MRlQiFVbfzKz0z8ocAEztTg8");
        template.setTouser("owU6X5JQiYPh41Sdf0bh_-b3LovE");//用户的openid
        template.setPage("www.baidu.com");
        List<TemplateParam> paras = new ArrayList<TemplateParam>();
        paras.add(new TemplateParam("thing1", "相亲大会"));
        paras.add(new TemplateParam("thing2", "创新谷中央花园11"));
        paras.add(new TemplateParam("date3", "2020年11月11日"));
        paras.add(new TemplateParam("thing5", "请盛装出席"));
        paras.add(new TemplateParam("name10", "佟丽娅"));
        template.setTemplateParamList(paras);
        WeiXinConfig weiXinConfig = new WeiXinConfig("wxa095e06a92f8d952", "8a9367ecd2d0bc6fa2ab02c8a8d8e44a");
        WeChatCommonResult weChatCommonResult = messageSubscribeSend(weiXinConfig, template);
        System.out.println(weChatCommonResult);

    }


}
