package cn.chiship.sdk.third.wechat.network;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.wechat.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.config.WeiXinConfig;

import cn.chiship.sdk.third.wechat.entity.pub.*;
import cn.chiship.sdk.third.wechat.entity.pub.message.MessageTemplateSend;
import com.alibaba.fastjson.JSONObject;

import org.apache.http.HttpResponse;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 微信服务工具类
 *
 * @author lijian
 */
public class WeiXinPubServicesUtils {


    /**
     * 获得accessToken
     *
     * @param weiXinConfig 微信公众号配置
     * @return 返回token
     */
    public static WeChatCommonResult getToken(WeiXinConfig weiXinConfig) {
        Map<String, String> query = new HashMap<>(7);
        query.put("grant_type", "client_credential");
        query.put("appid", weiXinConfig.getAppKey());
        query.put("secret", weiXinConfig.getAppSecret());
        try {
            String responseResult = HttpUtils.doGet(WeChatCommonConstants.WEI_XIN_SERVER_HOST, WeChatCommonConstants.GET_TOKEN, WeChatCommonConstants.commonHeaders(), query);
            WeChatCommonResult result = WeChatCommonConstants.analysisPubHttpResponse(responseResult);
            if (!result.isSuccess()) {
                return result;
            }
            JSONObject dataJson = (JSONObject) result.getData();
            String accessToken = dataJson.getString("access_token");
            result.setData(accessToken);
            return result;
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 获取用户基本信息
     *
     * @param weiXinConfig
     * @param openId
     * @return
     */
    public static WeChatCommonResult getUserInfo(WeiXinConfig weiXinConfig, String openId) {
        WeChatCommonResult chatCommonResult = getToken(weiXinConfig);
        if (!chatCommonResult.isSuccess()) {
            return chatCommonResult;
        }
        String token = chatCommonResult.getData().toString();
        Map<String, String> query = new HashMap<>(7);
        query.put("access_token", token);
        query.put("openid", openId);
        query.put("lang", "zh_CN");
        try {
            String responseResult = HttpUtils.doGet(WeChatCommonConstants.WEI_XIN_SERVER_HOST, WeChatCommonConstants.GET_USER_INFO, WeChatCommonConstants.commonHeaders(), query);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));

        }
    }

    /**
     * 创建自定义菜单
     *
     * @param weiXinConfig
     * @param menu
     * @return
     */
    public static WeChatCommonResult createMenu(WeiXinConfig weiXinConfig, Menu menu) {
        String token = null;
        WeChatCommonResult chatCommonResult = getToken(weiXinConfig);
        if (!chatCommonResult.isSuccess()) {
            return chatCommonResult;
        }
        token = chatCommonResult.getData().toString();
        Map<String, String> query = new HashMap<>(7);
        Map<String, Object> buttonMap = new HashMap<>(7);
        List firstButton = new ArrayList<>();
        for (Button button : menu.getButton()) {
            /**
             * 赋值
             */
            Map<String, Object> menuMap = new HashMap<>();
            menuMap.put("name", button.getName());
            menuMap.put("type", button.getType());
            if (WeChatCommonConstants.MENU_CLICK.equals(button.getType())) {
                menuMap.put("key", ((ClickButton) button).getKey());
            } else if (WeChatCommonConstants.MENU_VIEW.equals(button.getType())) {
                menuMap.put("url", ((ViewButton) button).getUrl());
            } else if (WeChatCommonConstants.MENU_MINIPROGRAM.equals(button.getType())) {
                menuMap.put("url", ((MiniprogramButton) button).getUrl());
                menuMap.put("appid", ((MiniprogramButton) button).getAppid());
                menuMap.put("pagepath", ((MiniprogramButton) button).getPagepath());
            }

            if (button.getSub_button() == null) {
                firstButton.add(menuMap);
            } else {
                Map<String, Object> secondMap = new HashMap<>(7);
                secondMap.put("name", button.getName());
                List secondButton = new ArrayList<>();
                for (Button SubButton : button.getSub_button()) {
                    Map<String, Object> second = new HashMap<>(7);
                    second.put("type", SubButton.getType());
                    second.put("name", SubButton.getName());
                    if (WeChatCommonConstants.MENU_CLICK.equals(SubButton.getType())) {
                        second.put("key", ((ClickButton) SubButton).getKey());
                        secondButton.add(second);
                    } else if (WeChatCommonConstants.MENU_VIEW.equals(SubButton.getType())) {
                        second.put("url", ((ViewButton) SubButton).getUrl());
                        secondButton.add(second);
                    } else if (WeChatCommonConstants.MENU_MINIPROGRAM.equals(SubButton.getType())) {
                        second.put("url", ((MiniprogramButton) SubButton).getUrl());
                        second.put("appid", ((MiniprogramButton) SubButton).getAppid());
                        second.put("pagepath", ((MiniprogramButton) SubButton).getPagepath());
                        secondButton.add(second);
                    }
                }
                secondMap.put("sub_button", secondButton);
                firstButton.add(secondMap);
            }
            buttonMap.put("button", firstButton);
        }
        System.out.println(JSONObject.toJSONString(buttonMap));
        try {
            String responseResult = HttpUtils.doPost(
                    WeChatCommonConstants.WEI_XIN_SERVER_HOST,
                    WeChatCommonConstants.CREATE_MENU_URL.replace("ACCESS_TOKEN", token),
                    WeChatCommonConstants.commonHeaders(),
                    query,
                    JSONObject.toJSONString(buttonMap)
            );
            WeChatCommonResult result = WeChatCommonConstants.analysisPubHttpResponse(responseResult);
            return result;
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }


    /**
     * @param weiXinConfig
     * @param nextOpenId   第一个拉取的OPENID，不填默认从头开始拉取
     * @return
     */
    public static WeChatCommonResult syncUser(WeiXinConfig weiXinConfig, String nextOpenId) {
        Map<String, String> query = new HashMap<>(7);
        try {
            WeChatCommonResult chatCommonResult = getToken(weiXinConfig);
            if (!chatCommonResult.isSuccess()) {
                return chatCommonResult;
            }
            String accessToken = chatCommonResult.getData().toString();
            String responseResult = HttpUtils.doGet(WeChatCommonConstants.WEI_XIN_SERVER_HOST,
                    WeChatCommonConstants.GET_USER_URL.replace("ACCESS_TOKEN", accessToken).replace("NEXT_OPENID", nextOpenId),
                    WeChatCommonConstants.commonHeaders(), query);
            WeChatCommonResult result = WeChatCommonConstants.analysisPubHttpResponse(responseResult);
            return result;
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }


    public static String getQRCode(String accessToken, String sceneStr) {
        Map<String, String> query = new HashMap<>(7);
        String data1 = "{\"expire_seconds\": 600, \"action_name\": \"QR_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": " + sceneStr + "}}}";
        try {
            String access_token = HttpUtils.doPost(WeChatCommonConstants.WEI_XIN_SERVER_HOST, WeChatCommonConstants.GET_QRCODE_TICKET.replace("ACCESS_TOKEN", accessToken), WeChatCommonConstants.commonHeaders(), query, data1);
            Object data = WeChatCommonConstants.analysisPubHttpResponse(access_token).getData();
            String ticket = JSONObject.parseObject(JSONObject.toJSONString(data)).getString("ticket");
            String qrCode = HttpUtils.doGet(WeChatCommonConstants.WEI_XIN_CODE_HOST, WeChatCommonConstants.CREATE_QRCODE_URL.replace("TICKET", URLEncoder.encode(ticket)), WeChatCommonConstants.commonHeaders(), query);
            /* ThirdResult result = WeChatCommonConstants.analysisHttpResponse(qrCode);*/
            return qrCode;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    public static WeChatCommonResult oauth2UserInfo(WeiXinConfig weiXinConfig, String code) {

        Map<String, String> query = new HashMap<>(7);
        try {
            String responseResult = HttpUtils.doGet(
                    WeChatCommonConstants.WEI_XIN_SERVER_HOST,
                    "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + weiXinConfig.getAppKey() + "&secret=" + weiXinConfig.getAppSecret() + "&code=" + code + "&grant_type=authorization_code",

                    WeChatCommonConstants.commonHeaders(), query);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));

        }
    }

    /**
     * 获得授权认证连接
     *
     * @param weiXinConfig
     * @param redirectUri
     * @param params
     * @return
     */
    public static String getConnectOauth2Url(WeiXinConfig weiXinConfig, String redirectUri, String params) {
        String url = WeChatCommonConstants.AGREE_URL
                .replace("APPID", weiXinConfig.getAppKey())
                .replace("REDIRECT_URI", URLEncoder.encode(redirectUri))
                .replace("SCOPE", "snsapi_userinfo");
        if (params != null) {
            url = url.replace("STATE", params);
        }
        return url;
    }

    /**
     * 通过code换取网页授权access_token
     *
     * @param weiXinConfig
     * @param code
     * @return
     */
    public static WeChatCommonResult oauth2AccessToken(WeiXinConfig weiXinConfig, String code) {

        Map<String, String> query = new HashMap<>(7);
        try {
            String url = WeChatCommonConstants.EXCHANGE_URL.replace("APPID", weiXinConfig.getAppKey()).replace("SECRET", weiXinConfig.getAppSecret()).replace("CODE", code);
            String responseResult = HttpUtils.doGet(url, "", WeChatCommonConstants.commonHeaders(), query);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 模板消息发送
     *
     * @return
     */
    public WeChatCommonResult messageTemplateSend(WeiXinConfig weiXinConfig, MessageTemplateSend messageTemplateSend) {
        Map<String, String> query = new HashMap<>(2);
        WeChatCommonResult chatCommonResult = getToken(weiXinConfig);
        if (!chatCommonResult.isSuccess()) {
            return chatCommonResult;
        }
        String accessToken = chatCommonResult.getData().toString();
        query.put("access_token", accessToken);
        try {
            String body = JSONObject.toJSONString(messageTemplateSend);
            String responseResult = HttpUtils.doPost(WeChatCommonConstants.WEI_XIN_SERVER_HOST, WeChatCommonConstants.MESSAGE_TEMPLATE_SEND, WeChatCommonConstants.commonHeaders(), query, body);
            return WeChatCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }


    public static void main(String[] args) {
        //    public static final String APP_KEY = "wx9c239da41112fa90";
        //    public static final String APP_SECRET = "f1c57964162c3ab5d7c5b3cd0a09a153";
        WeiXinConfig weiXinConfig = new WeiXinConfig("wxa095e06a92f8d952", "8a9367ecd2d0bc6fa2ab02c8a8d8e44a");
        System.out.println(createMenu(weiXinConfig, null));
        System.out.println(getToken(weiXinConfig));
    }


}
