package cn.chiship.sdk.third.wechat.network;


import cn.chiship.sdk.core.exception.ExceptionUtil;

import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.wechat.common.WeChatCommonConstants;
import cn.chiship.sdk.third.wechat.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.common.WeiXinMiniprogramCommonConstants;
import cn.chiship.sdk.third.wechat.config.WeiXinConfig;
import org.apache.http.HttpResponse;

import java.util.HashMap;
import java.util.Map;

public class WeiXinMiniprogramServices {
    /**
     * 通过code换取网页授权access_token
     * @param weiXinConfig
     * @param code  登录时code
     * @return
     */
    public static WeChatCommonResult code2Session(WeiXinConfig weiXinConfig, String code) {

        Map<String, String> query = new HashMap<>(7);
        query.put("grant_type", "authorization_code");
        query.put("appid", weiXinConfig.getAppKey());
        query.put("secret", weiXinConfig.getAppSecret());
        query.put("js_code", code);

        try {
            String responseResult = HttpUtils.doGet(
                    WeiXinMiniprogramCommonConstants.WEI_XIN_SERVER_HOST,
                    WeiXinMiniprogramCommonConstants.JSOCODE2SESSION,
                    WeChatCommonConstants.commonHeaders(), query);
            return WeiXinMiniprogramCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return  WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    public static void main(String[] args) {
        WeiXinConfig weiXinConfig =new WeiXinConfig("wx7bb57a751f9bfc92","a03dc45b15298c810670dfaaceb7cfbd");
        System.out.println(code2Session(weiXinConfig,"021RWuFa19OqyB0MJJIa1srSpx1RWuFI"));
    }
}
