package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.baidu.singleton.AipOcrClientSingleton;
import cn.chiship.sdk.third.common.ThirdResult;
import cn.chiship.sdk.third.common.ThirdResultEnum;
import cn.chiship.sdk.third.model.BaiDuOcrConfigModel;
import com.baidu.aip.ocr.AipOcr;

import org.json.JSONObject;

import java.util.Base64;
import java.util.HashMap;
import java.util.MissingResourceException;

/**
 * @author lijian
 */
public class BaiDuOcrUtils {
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuOcrUtils INSTANCE;

    private BaiDuOcrUtils() {
    }

    public static BaiDuOcrUtils getInstance() {
        if (INSTANCE == null) {
            synchronized (BaiDuOcrUtils.class) {
                if (INSTANCE == null) {
                    INSTANCE = new BaiDuOcrUtils();
                }
            }
        }
        return INSTANCE;
    }

    public BaiDuOcrUtils config() {
        try {
            BaiDuOcrConfigModel baiDuOcrConfigModel=new BaiDuOcrConfigModel(
                    PropertiesFileUtil.getInstance("chiship-third").get("BAI_DU_AI_API_KEY"),
                    PropertiesFileUtil.getInstance("chiship-third").get("BAI_DU_AI_SECRET_KEY"),
                    PropertiesFileUtil.getInstance("chiship-third").get("BAI_DU_AI_APP_ID")
            );
            if (StringUtil.isNullOrEmpty(baiDuOcrConfigModel.getAccesskeyId())||
                    StringUtil.isNullOrEmpty(baiDuOcrConfigModel.getAccesskeySecret()) ||
                    StringUtil.isNullOrEmpty(baiDuOcrConfigModel.getAppId())){
                throw new RuntimeException("兄弟,请确保百度AI的各个属性配置存在或值不为空!");
            }
            config(baiDuOcrConfigModel);
        }catch (MissingResourceException e){
            throw new RuntimeException("兄弟,请确保'chiship-third'文件存在!");
        }
        return this;
    }

    public BaiDuOcrUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel=baiDuOcrConfigModel;
        return this;
    }




    /**
     * 身份证识别
     *
     * @param sources 图片路径
     * @param isFront 身份证类型,true:正面,false:反面
     * @return
     */
    public ThirdResult idCardOcr(String sources, Boolean isFront, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<>(2);
        options.put("detect_direction", "true");
        options.put("detect_risk", "false");
        String idCardSide;

        if (isFront) {
            idCardSide = "front";
        } else {
            idCardSide = "back";
        }
        try {
            JSONObject res = null;
            if (isNetwork) {
                sources = ImageUtil.getImgStrByUrl(sources);
            } else {
                sources = ImageUtil.getImgStrByFile(sources);
            }
            Base64.Decoder decoder=Base64.getDecoder();
            res = client.idcard(decoder.decode(sources), idCardSide, options);
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
            return  ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 身份证识别
     *
     * @param image 图片路径
     * @param isFront 身份证类型,true:正面,false:反面
     * @return
     */
    public  ThirdResult idCardOcr(byte[] image, Boolean isFront) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<>(2);
        options.put("detect_direction", "true");
        options.put("detect_risk", "false");
        String idCardSide;

        if (isFront) {
            idCardSide = "front";
        } else {
            idCardSide = "back";
        }
        try {
            JSONObject res = client.idcard(image, idCardSide, options);
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
            return  ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 文字识别
     *
     * @param image     图片路径
     * @param isNetwork 是否为网络图片
     * @param type      图片类型
     * @return
     */
    public  ThirdResult characterRecognition(String image, Boolean isNetwork, String type) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        try {
            if (isNetwork) {
                image = ImageUtil.getImgStrByUrl(image);
            } else {
                image = ImageUtil.getImgStrByFile(image);
            }
            Base64.Decoder decoder=Base64.getDecoder();
            JSONObject res = null;

            if ("word".equals(type)) {
                options.put("language_type", "CHN_ENG");
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                options.put("probability", "true");
                res = client.basicGeneral(decoder.decode(image), options);
            }
            if ("highPrecisionWord".equals(type)) {
                options.put("detect_direction", "true");
                options.put("probability", "true");
                res = client.basicAccurateGeneral(decoder.decode(image), options);
            }
            if ("locationWord".equals(type)) {
                options.put("recognize_granularity", "big");
                options.put("language_type", "CHN_ENG");
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                options.put("vertexes_location", "true");
                options.put("probability", "true");
                res = client.general(decoder.decode(image), options);
            }
            if ("highLocationWord".equals(type)) {
                options.put("recognize_granularity", "big");
                options.put("detect_direction", "true");
                options.put("vertexes_location", "true");
                options.put("probability", "true");
                res = client.accurateGeneral(decoder.decode(image), options);
            }
            if ("rareWord".equals(type)) {
                options.put("language_type", "CHN_ENG");
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                options.put("probability", "true");
                res = client.enhancedGeneral(decoder.decode(image), options);
            }
            if ("webImage".equals(type)) {
                options.put("detect_direction", "true");
                options.put("detect_language", "true");
                res = client.webImage(decoder.decode(image), options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
            return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 银行卡识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult bankCard(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("detect_direction", "true");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.bankcard(file, options);
            } else {
                res = client.bankcard(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
            return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 驾驶证识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult drivingLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.drivingLicense(file, options);
            } else {
                res = client.drivingLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 行驶证识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult vehicleLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("detect_direction", "true");
        options.put("accuracy", "normal");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.vehicleLicense(file, options);
            } else {
                res = client.vehicleLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 车牌号识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult plateLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("multi_detect", "true");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.plateLicense(file, options);
            } else {
                res = client.plateLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 车牌号识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult businessLicense(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.businessLicense(file, options);
            } else {
                res = client.businessLicense(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 通行票据
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult receipt(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        options.put("probability", "true");
        options.put("accuracy", "normal");
        options.put("detect_direction", "true");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.receipt(file, options);
            } else {
                res = client.receipt(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 火车票识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult trainTicket(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.trainTicket(file, options);
            } else {
                res = client.trainTicket(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 出租车识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult taxiReceipt(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.taxiReceipt(file, options);
            } else {
                res = client.taxiReceipt(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 不能用  表格同步获取数据
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult form(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.form(file, options);
            } else {
                res = client.form(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }


    /**
     * 第一个方法获取requestId 第二个方法通过id获取结果
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult tableRecognitionAsync(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.tableRecognitionAsync(file, options);
            } else {
                res = client.tableRecognitionAsync(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    public   ThirdResult tableResultGet(String requestId) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("result_type", "json");
        JSONObject res;
        try {
            res = client.tableResultGet(requestId, options);
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 增值税发票识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult vatInvoice(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.vatInvoice(file, options);
            } else {
                res = client.vatInvoice(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 二维码
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult qrcode(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.qrcode(file, options);
            } else {
                res = client.qrcode(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 数字识别
     *
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult numbers(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        options.put("detect_direction", "true");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.numbers(file, options);
            } else {
                res = client.numbers(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 彩票 无权限
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult lottery(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.lottery(file, options);
            } else {
                res = client.lottery(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 护照
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult passport(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.passport(file, options);
            } else {
                res = client.passport(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 名片 不可用
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult businessCard(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.businessCard(file, options);
            } else {
                res = client.businessCard(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }

    /**
     * 手写 不准确
     * @param image
     * @param isNetwork
     * @return
     */
    public   ThirdResult handwriting(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("recognize_granularity", "big");
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.handwriting(file, options);
            } else {
                res = client.handwriting(image, options);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }
    public   ThirdResult tableRecognizeToJson(String image, Boolean isNetwork) {
        AipOcr client = AipOcrClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        JSONObject res;
        try {
            if (isNetwork) {
                byte[] file = ImageUtil.getImgByteByUrl(image);
                res = client.tableRecognizeToJson(file, 20000);
            } else {
                res = client.tableRecognizeToJson(image, 20000);
            }
            return BaiDuAiConstant.analysisJson(res);
        } catch (Exception e) {
             return  ThirdResult.error(ThirdResultEnum.ERROR_BAIDU_AI, ExceptionUtil.formatExceptionVo(e));
        }
    }


    public static void main(String[] args) {
        BaiDuOcrUtils baiDuOcrUtils= BaiDuOcrUtils.getInstance().config();

       // System.out.println(BaiDuAiResultAnalyze.analyzeOcr(baiDuOcrUtils.idCardOcr("C:\\Users\\Administrator\\Desktop\\新建文件夹\\894fe178fd0cb9f8861ee7e9bd47cec.jpg",true,false)));

        /*身份证*/
       /* System.out.println(BaiDuAiResultAnalyze.analyzeOCR(idCardOcr("C:\\Users\\Administrator\\Desktop\\微信图片_20181228154958.jpg",true,false)));
        System.out.println(idCardOcr("http://localhost:2222/upload/Expect-X-Test/image/player/20181215164415182_561.png",true,true));
        ThirdResult result=BaiDuAiResultAnalyze.analyzeOCR(idCardOcr("https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1545033017653&di=6832897cbf7c366ee3d1ff04530e5fb4&imgtype=0&src=http%3A%2F%2F5b0988e595225.cdn.sohucs.com%2Fimages%2F20181216%2F653d283e52b5491c9cccc74e5d7668ac.jpeg",false,true));
        System.out.println(result);*/

        //文字识别  生僻字无法调用接口
       /* String image = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564136745103&di=ff90e894d13ba91915efa4ad1cd905dd&imgtype=0&src=http%3A%2F%2Fpic.962.net%2Fup%2F2018-5%2F2018527102938219310.jpg";
        String locaImage = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564140117436&di=1e054e18cd1c92713df7f02740dbe9fe&imgtype=0&src=http%3A%2F%2Fphotocdn.sohu.com%2F20130529%2FImg377429405.jpg";
        String rareWord = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564144953580&di=112af7e95e0bf0e9c74ad70d6148adeb&imgtype=0&src=http%3A%2F%2F5b0988e595225.cdn.sohucs.com%2Fimages%2F20181223%2F8fdd34f77a304f0a9d45cf8171b07ce2.jpeg";
        String rareWord2 = "C:\\Users\\mechrevo\\Desktop\\timg3.jpg";
        String webImage = "http://www.grabsun.com/uploads/images/2012/60/2010031614114573.jpg";
        String webImage2 = "http://pic.baike.soso.com/p/20130729/20130729121225-684629691.jpg";
        System.out.println("文字识别"+getSampleWord((JSONObject) characterRecognition(image, true,"word").getData()));
        System.out.println("高精度文字识别"+getSampleWord((JSONObject) characterRecognition(rareWord, true,"highPrecisionWord").getData()));
        System.out.println("高精度文字识别(本地)"+getSampleWord((JSONObject) characterRecognition(rareWord2, false,"highPrecisionWord").getData()));
        System.out.println("生僻字文字识别"+(JSONObject) characterRecognition(image, true,"rareWord").getData());
        System.out.println("文字识别(含位置信息)"+((JSONObject)characterRecognition(rareWord, true, "locationWord").getData()).getJSONArray("words_result"));
        System.out.println("高精度识别生僻字"+((JSONObject)characterRecognition(rareWord, true, "highLocationWord").getData()).getJSONArray("words_result"));
        System.out.println("网络文字识别"+getSampleWord((JSONObject) characterRecognition(webImage, true,"webImage").getData()));
        */

        //银行卡识别
        /*String bankCard = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564203888147&di=c67a2979cf2c5e6167158b0c4a9b7470&imgtype=0&src=http%3A%2F%2Fp0.so.qhmsg.com%2Ft017b682c36e663d84f.jpg";
        String bankCard2 = "C:\\Users\\mechrevo\\Desktop\\timg2.jpg";
        System.out.println("银行卡" + bankCard(bankCard, true).getData());
        System.out.println("银行卡" + bankCard(bankCard2, false).getData());*/

        //驾驶证识别
        /*String drivingLicence = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564205500211&di=152f4a007c43763152bbb58dd770d096&imgtype=0&src=http%3A%2F%2F04.imgmini.eastday.com%2Fmobile%2F20180713%2F20180713195943_b3ef3bb3a55a600cf4e1fa41139358c4_5.jpeg";
        String drivingLicence2="C:\\Users\\mechrevo\\Desktop\\jiashi.jpg";
        System.out.println(drivingLicense(drivingLicence, true));
        System.out.println(drivingLicense(drivingLicence2, false));*/

        //行驶证识别
        /*String vehicleLicense = "https://ss0.bdstatic.com/70cFuHSh_Q1YnxGkpoWK1HF6hhy/it/u=3510470969,2617078641&fm=26&gp=0.jpg";
        String vehicleLicense3 = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564207045279&di=1693757c71dac896d61e88cf31e5cd8b&imgtype=0&src=http%3A%2F%2Fimg1.cache.netease.com%2Fcatchpic%2F3%2F3B%2F3BF7A0FB428A1F07A9B4E3AA5FA815CA.jpg";
        String vehicleLicense2 = "C:\\\\Users\\\\mechrevo\\\\Desktop\\\\xingshi.jpg";
        System.out.println(vehicleLicense(vehicleLicense3, true));
        System.out.println(vehicleLicense(vehicleLicense2, false));*/

        //车牌号识别
      /*  String plateLicense = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564219338842&di=3af499b3afc9638064a75ce861e24050&imgtype=0&src=http%3A%2F%2Fp0.qhimg.com%2Ft01b0f6bc869c6655cb.jpg";
        String plateLicense2 ="C:\\Users\\mechrevo\\Desktop\\chepai.jpg";
        System.out.println("车牌号识别"+plateLicense(plateLicense, true));
        System.out.println("车牌号识别"+plateLicense(plateLicense2, false));*/

        //营业执照识别
        /*String businessLicense = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564219757780&di=4e2feb0e6794ca4e40d323c5d33642fc&imgtype=0&src=http%3A%2F%2Fbaoliao.oeeee.com%2Fupload%2F2%2F2014-0%2F650XH%2F62df72e8-a41a-4386-973b-f8b93e98d8f0.jpg";
        String businessLicense2 ="C:\\Users\\mechrevo\\Desktop\\yingye.jpg";
        System.out.println(businessLicense(businessLicense, true));
        System.out.println(businessLicense(businessLicense2, false));*/
        //通行票据
        /*String receipt = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564220112018&di=d6e0fa60605cafecb483857231c51bc3&imgtype=0&src=http%3A%2F%2Fpic05.997788.com%2Fpic_search%2F00%2F21%2F82%2F17%2Fse21821788.jpg";
        String receipt2 ="C:\\Users\\mechrevo\\Desktop\\tongxing.jpg";
        System.out.println(receipt(receipt, true));
        System.out.println(receipt(receipt2, false));*/

        //火车票
       /* String trainTicket = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564220570131&di=5a0cf8f40d84bf92a00da94d562319ba&imgtype=0&src=http%3A%2F%2Fwww.kfzimg.com%2FG06%2FM00%2FB3%2FF3%2Fp4YBAFsWJjSAVX9rAAElmabQfWE934_n.jpg";
        String trainTicket2 = "C:\\Users\\mechrevo\\Desktop\\huoche.jpg";
        System.out.println(trainTicket(trainTicket, true));
        System.out.println(trainTicket(trainTicket2, false));*/

        //出租车
        /*String taxiReceipt = "https://ss0.bdstatic.com/70cFvHSh_Q1YnxGkpoWK1HF6hhy/it/u=3286190998,3577867542&fm=26&gp=0.jpg";
        String taxiReceipt2 ="C:\\Users\\mechrevo\\Desktop\\chuzu.jpg";
        System.out.println(taxiReceipt(taxiReceipt, true));
        System.out.println(taxiReceipt(taxiReceipt2, false));*/

        //表格文字识别同步
        String form = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564221438521&di=79be98b999d4ea989a92106b94e70dc6&imgtype=0&src=http%3A%2F%2Fimg.9553.com%2Fupload%2F2014%2F3%2F21%2F2014032155052157.jpg";
        String form2 = "C:\\Users\\mechrevo\\Desktop\\biaoge.jpg";
       /* System.out.println(form(form, true));
        System.out.println(form(form2, false));*/

        /*JSONArray result = ((JSONObject) tableRecognitionAsync(form2, false).getData()).getJSONArray("result");
        JSONObject json = (JSONObject)result.get(0);
        String requestId = json.getString("request_id");
        System.out.println(requestId);*/
        //该方法会返回一个解析状态 需判断状态
        /*System.out.println(tableResultGet("16893148_1086361"));*/
        //该方法为封装好的轮询方法 方法参数为文件路径,等待时间
        /*System.out.println(tableRecognizeToJson(form, true));
        System.out.println(tableRecognizeToJson(form2, false));*/

        //增值税发票
       /* String vatInvoice="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564224726079&di=040feff77d811394b0f66f3e9885772c&imgtype=0&src=http%3A%2F%2Fimg.alicdn.com%2Fimgextra%2Fi4%2F653300302%2FTB2Ak4wipXXXXaiXpXXXXXXXXXX_%2521%2521653300302.jpg";
        String vatInvoice2="C:\\Users\\mechrevo\\Desktop\\zengzhi.jpg";
        System.out.println(vatInvoice(vatInvoice, true));
        System.out.println(vatInvoice(vatInvoice2, false));*/

        //二维码 不能调用 需要合作咨询
       /*String qrcode = "https://ss0.bdstatic.com/70cFuHSh_Q1YnxGkpoWK1HF6hhy/it/u=607519565,2848664099&fm=26&gp=0.jpg";
        String qrcode2 ="C:\\Users\\mechrevo\\Desktop\\erwei.jpg";
        System.out.println(qrcode(qrcode, true));
        System.out.println(qrcode(qrcode2, false));*/

        //数字识别
    /*    String numbers = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564225757348&di=2274dbfc0425166cc35a253221424cf1&imgtype=0&src=http%3A%2F%2Ff.hiphotos.baidu.com%2Fzhidao%2Fpic%2Fitem%2F0eb30f2442a7d9336d8e930daf4bd11373f001ad.jpg";
        String numbers2 = "C:\\Users\\mechrevo\\Desktop\\kuaidi.jpg";
        System.out.println(numbers(numbers, true));
        System.out.println(numbers(numbers2, false));*/

       //识别
        /*String lottery = "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226149210&di=e7a91626902ab948c549e7e8b0866f50&imgtype=0&src=http%3A%2F%2Fwww.hinews.cn%2Fpic%2F0%2F17%2F04%2F99%2F17049949_520811.jpg";
        String lottery2 = "C:\\Users\\mechrevo\\Desktop\\caipiao.jpg";
        System.out.println(lottery(lottery, true));
        System.out.println(lottery(lottery2, false));*/

        //护照
        /*String passport ="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226314274&di=580271803bba034724452fd6f240498c&imgtype=0&src=http%3A%2F%2Fresources.csi.com.cn%2FuploadFile%2Fa798ed73-6716-49f8-9549-675f4bec58d6.jpg";
        String passport2 ="C:\\Users\\mechrevo\\Desktop\\huzhao.jpg";
        System.out.println(passport(passport, true));
        System.out.println(passport(passport2, false));*/

       /* String businessCard ="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226625151&di=2a78632be84fdef6fa8c6687cf0541ad&imgtype=0&src=http%3A%2F%2Fpic26.nipic.com%2F20130124%2F7074791_213018367135_2.jpg";
        String businessCard2="C:\\Users\\mechrevo\\Desktop\\mingpian.jpg";
        System.out.println(businessCard(businessCard, true));
        System.out.println(businessCard(businessCard2, false));*/

      /* String handwriting ="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1564226992137&di=88353fc33509dcce80dd693f630fc650&imgtype=0&src=http%3A%2F%2Fb-ssl.duitang.com%2Fuploads%2Fitem%2F201803%2F23%2F20180323225334_seiob.jpg";
        String handwriting2 ="C:\\Users\\mechrevo\\Desktop\\shou.jpg";
        System.out.println(handwriting(handwriting, true));
        System.out.println(handwriting(handwriting2, false));*/
    }
}





