package cn.chiship.sdk.third.ali;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.common.ThirdResult;
import cn.chiship.sdk.third.common.ThirdResultEnum;
import cn.chiship.sdk.third.model.AliOssConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ObjectMetadata;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.MissingResourceException;

/**
 * @author lijian
 * 阿里云储工具类
 */
public class AliOssUtil {
    static Logger LOGGER = Logger.getLogger(AliDySmsUtil.class);
    private AliOssConfigModel aliOssConfigModel;
    private static AliOssUtil INSTANCE;

    private AliOssUtil() {
    }

    public static AliOssUtil getInstance() {
        if (INSTANCE == null) {
            synchronized (AliOssUtil.class) {
                if (INSTANCE == null) {
                    INSTANCE = new AliOssUtil();
                }
            }
        }
        return INSTANCE;
    }

    public AliOssUtil config() {
        try {
            AliOssConfigModel emailConfigModel = new AliOssConfigModel(
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_OSS_ACCESS_KEY_ID"),
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_OSS_ACCESS_KEY_SECRET"),
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_OSS_END_PORT"),
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_OSS_BUCK_NAME"),
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_OSS_ROOT")
            );
            if (StringUtil.isNullOrEmpty(emailConfigModel.getAccesskeyId()) ||
                    StringUtil.isNullOrEmpty(emailConfigModel.getAccesskeySecret()) ||
                    StringUtil.isNullOrEmpty(emailConfigModel.getOssEndPort()) ||
                    StringUtil.isNullOrEmpty(emailConfigModel.getBuckName()) ||
                    StringUtil.isNullOrEmpty(emailConfigModel.getRoot())) {
                throw new RuntimeException("兄弟,请确保阿里云存储的各个属性配置存在或值不为空!");
            }
            config(emailConfigModel);
        } catch (MissingResourceException e) {
            throw new RuntimeException("兄弟,请确保'chiship-third'文件存在!");
        }
        return this;
    }

    public AliOssUtil config(AliOssConfigModel aliOssConfigModel) {
        this.aliOssConfigModel = aliOssConfigModel;
        return this;
    }


    public ThirdResult upload(String catalog, String imageName, InputStream in) {
        try {
            String fileUrl;
            OSSClient client = new OSSClient(
                    this.aliOssConfigModel.getOssEndPort(),
                    this.aliOssConfigModel.getAccesskeyId(),
                    this.aliOssConfigModel.getAccesskeySecret());
            if (StringUtils.isNotEmpty(catalog)) {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName, in);
            } else {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + imageName, in);
            }
            client.shutdown();
            LOGGER.info("文件上传成功");
            return  ThirdResult.ok(fileUrl);

        } catch (OSSException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (ClientException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (Exception e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException(e));

        }
    }

    public ThirdResult uploadBase64(String catalog, String imageName, String base64) {
        try {
            String fileUrl;

            OSSClient client = new OSSClient(
                    this.aliOssConfigModel.getOssEndPort(),
                    this.aliOssConfigModel.getAccesskeyId(),
                    this.aliOssConfigModel.getAccesskeySecret());
            Base64.Decoder decoder=Base64.getDecoder();
            byte[] bytes = decoder.decode(base64);
            InputStream inputStream = new ByteArrayInputStream(bytes);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(inputStream.available());
            if (StringUtils.isNotEmpty(catalog)) {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + imageName, inputStream);
            } else {
                fileUrl = "http://" + this.aliOssConfigModel.getBuckName() + "." + this.aliOssConfigModel.getOssEndPort() + "/" + this.aliOssConfigModel.getRoot() + "/" + imageName;
                client.putObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot() + "/" + imageName, inputStream);
            }
            client.shutdown();
            LOGGER.info("文件上传成功");

            return  ThirdResult.ok(fileUrl);
        }  catch (OSSException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (ClientException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (Exception e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException(e));

        }
    }

    public ThirdResult remove(String objectName) {
        try {
            OSSClient client = new OSSClient(
                    "http://"+this.aliOssConfigModel.getOssEndPort(),
                    this.aliOssConfigModel.getAccesskeyId(),
                    this.aliOssConfigModel.getAccesskeySecret());

            client.deleteObject(this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getRoot()+"/"+objectName);

            client.shutdown();
            LOGGER.info("文件刪除成功");
            return  ThirdResult.ok(null);
        }  catch (OSSException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (ClientException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (Exception e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException(e));

        }
    }
    public ThirdResult remove(List<String> objectNames) {
        try {
            OSSClient client = new OSSClient(
                    "http://"+this.aliOssConfigModel.getOssEndPort(),
                    this.aliOssConfigModel.getAccesskeyId(),
                    this.aliOssConfigModel.getAccesskeySecret());
            List<String>trueObjectNames=new ArrayList<>();
            for (String objectName:objectNames ){
                trueObjectNames.add(this.aliOssConfigModel.getRoot()+"/"+objectName);
            }
            DeleteObjectsResult deleteObjectsResult = client.deleteObjects(new DeleteObjectsRequest(this.aliOssConfigModel.getBuckName()).withKeys(trueObjectNames));
            List<String> deletedObjects = deleteObjectsResult.getDeletedObjects();
            client.shutdown();
            LOGGER.info("文件刪除成功");
            return  ThirdResult.ok(null);
        }  catch (OSSException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (ClientException e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getErrorMessage());
            return ThirdResult.error(ThirdResultEnum.ERROR_ALI_OSS, e.getErrorMessage());
        }catch (Exception e) {
            LOGGER.error("AliOssUtil发生错误:" + e.getLocalizedMessage());
            return ThirdResult.error(ExceptionUtil.formatException(e));

        }
    }


    public static void main(String[] args) throws Exception {
        AliOssUtil aliOssUtil=AliOssUtil.getInstance().config();
       // LOGGER.info(aliOssUtil.upload("user", "1111.pptx", new FileInputStream("C:\\Users\\Administrator\\Desktop\\八达物联网Expect-X （Version1.0）.pptx")));
        //LOGGER.info(aliOssUtil.remove("chiship/user/1111.pptx"));
        List<String>projectNames=new ArrayList<>();
        projectNames.add("chiship/user/1111.pptx");
        projectNames.add("chiship/user/1111.pptx ");
        LOGGER.info(JSON.toJSONString(aliOssUtil.remove(projectNames)));
    }
}
