package cn.chiship.sdk.third.ali;


import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.common.ThirdConstants;
import cn.chiship.sdk.third.common.ThirdResult;
import cn.chiship.sdk.third.common.ThirdResultEnum;
import cn.chiship.sdk.third.model.BaseConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

/**
 * @author lijian
 * 阿里云短信工具
 */
public class AliDySmsUtil {
    static Logger LOGGER=Logger.getLogger(AliDySmsUtil.class);
    static final String PRODUCT = "Dysmsapi";
    static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private static String  aliDySmsSignName;
    private static String aliDySmsTemplateCode;
    private BaseConfigModel baseConfigModel;
    private static AliDySmsUtil INSTANCE;

    private AliDySmsUtil() {
    }

    public static AliDySmsUtil getInstance() {
        if (INSTANCE == null) {
            synchronized (AliDySmsUtil.class) {
                if (INSTANCE == null) {
                    INSTANCE = new AliDySmsUtil();
                }
            }
        }
        return INSTANCE;
    }

    public AliDySmsUtil config() {
        try {
            BaseConfigModel baseConfigModel=new BaseConfigModel(
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_ACCESSKEY_ID"),
                    PropertiesFileUtil.getInstance("chiship-third").get("ALI_ACCESSKEY_SECRET")
            );
            if (StringUtil.isNullOrEmpty(baseConfigModel.getAccesskeyId())||
                    StringUtil.isNullOrEmpty(baseConfigModel.getAccesskeySecret()) ){
                throw new RuntimeException("兄弟,请确保阿里云短信的各个属性配置存在或值不为空!");
            }
            config(baseConfigModel);
        }catch (MissingResourceException e){
            throw new RuntimeException("兄弟,请确保'chiship-third'文件存在!");
        }
        return this;
    }

    public AliDySmsUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel=baseConfigModel;
        return this;
    }


    public AliDySmsUtil load(String signName,String templateCode ) {
        aliDySmsSignName=signName;
        aliDySmsTemplateCode = templateCode;
        return this;
    }


    public ThirdResult sendSms(String mobile, Map<String,String>paramsMap){
        Boolean flag=false;
        String msg;
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");

            IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", this.baseConfigModel.getAccesskeyId(), this.baseConfigModel.getAccesskeySecret());
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", PRODUCT, DOMAIN);
            IAcsClient acsClient = new DefaultAcsClient(profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setPhoneNumbers(mobile);
            request.setSignName(aliDySmsSignName);
            request.setTemplateCode(aliDySmsTemplateCode);
            if (null!=paramsMap){
                request.setTemplateParam(JSON.toJSONString(paramsMap));
            }
            SendSmsResponse response = acsClient.getAcsResponse(request);
            LOGGER.info("短信接口返回的数据----------------");
             LOGGER.info("Code=" + response.getCode());
             LOGGER.info("Message=" + response.getMessage());
             LOGGER.info("RequestId=" + response.getRequestId());
            if(response.getCode() != null && ThirdConstants.STRING_OK.equals( response.getCode())) {
                QuerySendDetailsResponse querySendDetailsResponse = querySendDetails(response.getBizId());
                 LOGGER.info("短信明细查询接口返回数据----------------");
                 LOGGER.info("Code=" + querySendDetailsResponse.getCode());
                 LOGGER.info("Message=" + querySendDetailsResponse.getMessage());
                return  ThirdResult.ok(null);
            }else{
                return  ThirdResult.error(ThirdResultEnum.ERROR_ALI_DY_SMS, response.getMessage());
            }
        }catch (Exception e){
            LOGGER.error("SmsUtil发生错误:"+e.getLocalizedMessage());
            return  ThirdResult.error(ExceptionUtil.formatException(e));
        }

    }

    public  QuerySendDetailsResponse querySendDetails(String bizId) throws ClientException {

        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou",  this.baseConfigModel.getAccesskeyId(), this.baseConfigModel.getAccesskeySecret());
        DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", PRODUCT, DOMAIN);
        IAcsClient acsClient = new DefaultAcsClient(profile);

        QuerySendDetailsRequest request = new QuerySendDetailsRequest();
        request.setPhoneNumber("15000000000");
        request.setBizId(bizId);
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
        request.setSendDate(ft.format(new Date()));
        request.setPageSize(10L);
        request.setCurrentPage(1L);

        QuerySendDetailsResponse querySendDetailsResponse = acsClient.getAcsResponse(request);

        return querySendDetailsResponse;
    }

    public static void main(String[] args) throws ClientException, InterruptedException {
        AliDySmsUtil aliDySmsUtil=AliDySmsUtil.getInstance().config();
        Map<String,String>paramsMap= new HashMap<>(2);
        paramsMap.put("code","123421");
        aliDySmsUtil.load("智舰工作室","SMS_147418172");
         LOGGER.info(aliDySmsUtil.sendSms("18363003321",paramsMap));
    }
}
