package cn.chiship.sdk.third;


import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.common.ThirdResult;
import cn.chiship.sdk.third.model.BaseConfigModel;
import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import com.alibaba.fastjson.JSON;

import io.netty.handler.codec.http.HttpMethod;
import org.apache.log4j.Logger;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

/**
 * @author lijian
 * 极光推送工具类
 */
public class PushUtil {
    protected static final Logger LOGGER = Logger.getLogger(PushUtil.class);
    private BaseConfigModel baseConfigModel;
    private static PushUtil INSTANCE;

    private PushUtil() {
    }

    public static PushUtil getInstance() {
        if (INSTANCE == null) {
            synchronized (PushUtil.class) {
                if (INSTANCE == null) {
                    INSTANCE = new PushUtil();
                }
            }
        }
        return INSTANCE;
    }

    public PushUtil config() {
        try {
            BaseConfigModel baseConfigModel = new BaseConfigModel(
                    PropertiesFileUtil.getInstance("chiship-third").get("JPUSH_APP_KEY"),
                    PropertiesFileUtil.getInstance("chiship-third").get("JPUSH_MASTER_SECRET")
            );
            if (StringUtil.isNullOrEmpty(baseConfigModel.getAccesskeyId()) ||
                    StringUtil.isNullOrEmpty(baseConfigModel.getAccesskeySecret())) {
                throw new RuntimeException("兄弟,请确保极光推送的各个属性配置存在或值不为空!");
            }
            config(baseConfigModel);
        } catch (MissingResourceException e) {
            throw new RuntimeException("兄弟,请确保'chiship-third'文件存在!");
        }
        return this;
    }

    public PushUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }



    /**
     * 根据设备别名推送消息
     * @param alias         別名
     * @param title         标题
     * @param content       内容
     * @param extras        扩展参数
     */
    public ThirdResult sendPushWithAlias(String alias, String title, String content, Map<String, String> extras) {
        ClientConfig clientConfig = ClientConfig.getInstance();
        String host = (String) clientConfig.get(ClientConfig.PUSH_HOST_NAME);
        final NettyHttpClient client = new NettyHttpClient(ServiceHelper.getBasicAuthorization(this.baseConfigModel.getAccesskeyId(), this.baseConfigModel.getAccesskeySecret()),
                null, clientConfig);
        try {
            URI uri = new URI(host + clientConfig.get(ClientConfig.PUSH_PATH));

            PushPayload payload = PushPayload.newBuilder()
                    .setPlatform(Platform.all())
                    .setAudience(Audience.alias(alias))
                    .setNotification(buildNotification(title,content,extras))
                    .build();
            client.sendRequest(HttpMethod.POST, payload.toString(), uri, new NettyHttpClient.BaseCallback() {
                @Override
                public void onSucceed(ResponseWrapper responseWrapper) {
                    LOGGER.info("发送结果: " + responseWrapper.responseContent);

                }
            });
            return ThirdResult.ok("消息推送成功");
        } catch (URISyntaxException e) {
            e.printStackTrace();
            return  ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 根据设备组推送消息
     * @param tag           设备组
     * @param title         标题
     * @param content       内容
     * @param extras        扩展参数
     */
    public  void sendPushWithTag(String tag,String title,String content, Map<String, String> extras) {
        ClientConfig clientConfig = ClientConfig.getInstance();
        String host = (String) clientConfig.get(ClientConfig.PUSH_HOST_NAME);
        final NettyHttpClient client = new NettyHttpClient(ServiceHelper.getBasicAuthorization(this.baseConfigModel.getAccesskeyId(), this.baseConfigModel.getAccesskeySecret()),
                null, clientConfig);
        try {
            URI uri = new URI(host + clientConfig.get(ClientConfig.PUSH_PATH));

            PushPayload payload = PushPayload.newBuilder()
                    .setPlatform(Platform.android())
                    .setAudience(Audience.tag(tag))
                    .setNotification(buildNotification(title,content,extras))
                    .build();
            client.sendRequest(HttpMethod.POST, payload.toString(), uri, new NettyHttpClient.BaseCallback() {
                @Override
                public void onSucceed(ResponseWrapper responseWrapper) {
                    LOGGER.info("Got result: " + responseWrapper.responseContent);
                }
            });
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

    }

    /**
     * 向所有设备推送消息
     * @param title         标题
     * @param content       内容
     * @param extras        扩展参数
     */
    public  ThirdResult sendPushWithAll(String title,String content, Map<String, String> extras) {
        ClientConfig config = ClientConfig.getInstance();
        config.setPushHostName("https://api.jpush.cn");

        JPushClient jpushClient = new JPushClient( this.baseConfigModel.getAccesskeySecret(),this.baseConfigModel.getAccesskeyId(), null, config);
        PushPayload payload = PushPayload.newBuilder()
                .setPlatform(Platform.all())
                .setAudience(Audience.all())
                .setNotification(buildNotification(title,content,extras))
                .build();

        try {
            PushResult result = jpushClient.sendPush(payload);
            LOGGER.info("发送结果- " + result);
            return  ThirdResult.ok("消息推送成功");
        } catch (APIConnectionException e) {
            return  ThirdResult.error(ExceptionUtil.formatException(e));
        } catch (APIRequestException e) {
            return  ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 构建通知
     * @param title
     * @param content
     * @param extras
     * @return
     */
    private static Notification buildNotification(String title,String content,Map extras){
        return  Notification.newBuilder()
                .setAlert(content)
                .addPlatformNotification(AndroidNotification.newBuilder()
                        .setTitle(title)
                        .addExtras(extras).build())
                .addPlatformNotification(IosNotification.newBuilder()
                        .incrBadge(1)
                        .addExtra("extras", JSON.toJSONString(extras)).build())
                .build();
    }

    public static void main(String[] args) throws Exception{
        PushUtil pushUtil=PushUtil.getInstance().config();
        Map<String,String>extras= new HashMap<>(2);
        extras.put("orderId","11111");
        extras.put("type","orderPay");
        extras.put("paySuccess","true");
        ThirdResult baseResult=pushUtil.sendPushWithAlias("9_ED2965CDF644403CB51B100A0C767B64","您有新的订单","订单:英国进口 麦维他（Mcvitie's）原味全麦粗粮酥性消化饼干 400g 早餐下午茶零食",extras);
        LOGGER.info(baseResult);
    }

}
