/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.enums.HeaderEnum;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.Base64Util;
import cn.chiship.sdk.core.util.FileUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class File2Util
extends FileUtil {
    public static String readResourceFile(String file) {
        try {
            String s;
            ClassPathResource resource = new ClassPathResource(file);
            InputStream is = resource.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s + "\n");
            }
            br.close();
            isr.close();
            is.close();
            return sb.toString();
        }
        catch (Exception e) {
            throw new SystemErrorException("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef" + file);
        }
    }

    public static byte[] readResource(String file) {
        try {
            ClassPathResource resource = new ClassPathResource(file);
            InputStream is = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            is.close();
            return bytes;
        }
        catch (Exception e) {
            throw new SystemErrorException("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef" + file);
        }
    }

    public static void setAttachmentResponseHeader(HttpServletResponse response, String realFileName) {
        String percentEncodedFileName = File2Util.percentEncode(realFileName);
        StringBuilder contentDispositionValue = new StringBuilder();
        contentDispositionValue.append("attachment; filename=").append(percentEncodedFileName).append(";").append("filename*=").append("utf-8''").append(percentEncodedFileName);
        response.setHeader(HeaderEnum.HEADER_CONTENT_DISPOSITION.getName(), contentDispositionValue.toString());
        response.setHeader(HeaderEnum.HEADER_DOWNLOAD_FILENAME.getName(), percentEncodedFileName);
    }

    public static String percentEncode(String s) {
        String encode = Base64Util.encode((byte[])s.getBytes());
        return encode.replaceAll("\\+", "%20");
    }
}

