/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.util.CsvUtils;
import cn.chiship.sdk.core.util.OutUtil;
import cn.chiship.sdk.core.util.excel.ExcelHSSFUtil;
import cn.chiship.sdk.core.util.excel.ExcelXSSFUtil;
import cn.chiship.sdk.framework.util.File2Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ExportUtil {
    private static ExportUtil exportUtil;

    private ExportUtil() {
    }

    public static synchronized ExportUtil getInstance() {
        if (exportUtil == null) {
            exportUtil = new ExportUtil();
        }
        return exportUtil;
    }

    public byte[] getExportBytesByType(String exportType, String sheetName, String sheetTitle, List<String> labels, List<List<String>> valueList) throws Exception {
        byte[] bytes;
        if (labels.size() != valueList.get(0).size()) {
            return new byte[0];
        }
        labels.add(0, "\u5e8f\u53f7");
        AtomicInteger index = new AtomicInteger(1);
        valueList.forEach(item -> item.add(0, String.valueOf(index.getAndIncrement())));
        switch (exportType) {
            case "xls": {
                bytes = ExcelHSSFUtil.getWriteExcelBytes((String)sheetName, (String)sheetTitle, labels, valueList);
                break;
            }
            case "xlsx": {
                bytes = ExcelXSSFUtil.getWriteExcelBytes((String)sheetName, (String)sheetTitle, labels, valueList);
                break;
            }
            case "csv": {
                bytes = CsvUtils.getWriteCsvBytes(labels, valueList);
                break;
            }
            case "json": {
                bytes = this.analysisJSON(labels, valueList).toString().getBytes(StandardCharsets.UTF_8);
                break;
            }
            case "txt": {
                StringBuilder write = new StringBuilder();
                String doubleTab = "        ";
                String enter = "\r\n";
                for (String string : labels) {
                    write.append(string).append(doubleTab);
                }
                write.append(enter);
                for (List list : valueList) {
                    for (String val : list) {
                        write.append(val).append(doubleTab);
                    }
                    write.append(enter);
                }
                bytes = write.toString().getBytes(StandardCharsets.UTF_8);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u8bc6\u522b\u7684\u5bfc\u51fa\u683c\u5f0f\uff1a" + exportType);
            }
        }
        return bytes;
    }

    public void exportByType(HttpServletResponse response, String exportType, String fileName, byte[] bytes) throws Exception {
        ServletOutputStream os = response.getOutputStream();
        switch (exportType) {
            case "xls": 
            case "xlsx": {
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                break;
            }
            case "csv": {
                response.setContentType("application/ms-txt.numberformat:@;charset=GBK");
                break;
            }
            case "json": {
                response.setContentType("text/plain;charset=utf-8");
                break;
            }
            case "txt": {
                response.setContentType("text/plain");
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u8bc6\u522b\u7684\u8f93\u51fa\u683c\u5f0f\uff1a" + exportType);
            }
        }
        File2Util.setAttachmentResponseHeader(response, fileName + "." + exportType);
        os.write(bytes);
        os.flush();
        os.close();
    }

    public void exportByType(HttpServletResponse response, String exportType, String fileName, String sheetName, String sheetTitle, List<String> labels, List<List<String>> valueList) throws Exception {
        if (valueList.isEmpty()) {
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55!"));
            return;
        }
        if (labels.size() != valueList.get(0).size()) {
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u6807\u9898\u5217\u6570\u4e0e\u6570\u503c\u5217\u6570\u4e0d\u5339\u914d!"));
            return;
        }
        labels.add(0, "\u5e8f\u53f7");
        AtomicInteger index = new AtomicInteger(1);
        valueList.forEach(item -> item.add(0, String.valueOf(index.getAndIncrement())));
        switch (exportType) {
            case "xls": 
            case "xlsx": {
                this.exportExcel(fileName, sheetName, sheetTitle, labels, valueList, response, exportType);
                break;
            }
            case "csv": {
                this.exportCsv(fileName, labels, valueList, response, exportType);
                break;
            }
            case "json": {
                this.exportJson(fileName, this.analysisJSON(labels, valueList), response, exportType);
                break;
            }
            case "txt": {
                this.exportTxt(fileName, labels, valueList, response, exportType);
                break;
            }
            default: {
                OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u683c\u5f0f"));
            }
        }
    }

    private JSONArray analysisJSON(List<String> labels, List<List<String>> valueList) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < valueList.size(); ++i) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int j = 0; j < labels.size(); ++j) {
                map.put(labels.get(j), valueList.get(i).get(j));
            }
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(map));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public void exportCsv(String fileName, List<String> columnLabel, List<List<String>> columnValue, HttpServletResponse response, String exportType) throws IOException {
        response.setContentType("application/ms-txt.numberformat:@;charset=GBK");
        File2Util.setAttachmentResponseHeader(response, fileName + "." + exportType);
        ServletOutputStream os = response.getOutputStream();
        CsvUtils.writeCsv((OutputStream)os, columnLabel, columnValue);
        os.flush();
        os.close();
    }

    public void exportJson(String fileName, JSONArray jsonArray, HttpServletResponse response, String exportType) throws IOException {
        response.setContentType("text/plain;charset=utf-8");
        File2Util.setAttachmentResponseHeader(response, fileName + "." + exportType);
        ServletOutputStream os = response.getOutputStream();
        os.write(jsonArray.toString().getBytes(StandardCharsets.UTF_8));
        os.flush();
        os.close();
    }

    public void exportTxt(String fileName, List<String> columnLabel, List<List<String>> columnValue, HttpServletResponse response, String exportType) throws IOException {
        StringBuilder write = new StringBuilder();
        String doubleTab = "        ";
        String enter = "\r\n";
        for (String string : columnLabel) {
            write.append(string).append(doubleTab);
        }
        write.append(enter);
        for (List list : columnValue) {
            for (String val : list) {
                write.append(val).append(doubleTab);
            }
            write.append(enter);
        }
        response.setContentType("text/plain");
        File2Util.setAttachmentResponseHeader(response, fileName + "." + exportType);
        BufferedOutputStream buff = new BufferedOutputStream((OutputStream)response.getOutputStream());
        buff.write(write.toString().getBytes(StandardCharsets.UTF_8));
        buff.flush();
        buff.close();
    }

    public void exportExcel(String fileName, String sheetName, String sheetTitle, List<String> headerNames, List<List<String>> values, HttpServletResponse response, String exportType) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        ServletOutputStream os = response.getOutputStream();
        File2Util.setAttachmentResponseHeader(response, fileName + "." + exportType);
        if ("xls".equals(exportType)) {
            ExcelHSSFUtil.writeExcel((OutputStream)os, (String)sheetName, (String)sheetTitle, headerNames, values);
        } else {
            ExcelXSSFUtil.writeExcel((OutputStream)os, (String)sheetName, (String)sheetTitle, headerNames, values);
        }
        os.flush();
        os.close();
    }
}

