/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.ue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private final String rootPath;
    private final String originalPath;
    private static final String CONFIG_FILE_NAME = "UEConfig.json";
    private String parentPath = null;
    private String jsonConfigFilePath;
    private JSONObject jsonConfig = null;
    private static final String SCRAWL_FILE_NAME = "scrawl";
    private static final String REMOTE_FILE_NAME = "remote";

    private ConfigManager(String rootPath, String jsonConfigFilePath, String contextPath, String uri) throws IOException {
        this.rootPath = rootPath = rootPath.replace("\\", "/");
        this.originalPath = this.rootPath + uri;
        this.parentPath = new File(jsonConfigFilePath).getParent();
        this.jsonConfigFilePath = jsonConfigFilePath;
        this.initEnv();
    }

    public static ConfigManager getInstance(String rootPath, String jsonConfigFilePath, String contextPath, String uri) {
        try {
            return new ConfigManager(rootPath, jsonConfigFilePath, contextPath, uri);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public boolean valid() {
        return this.jsonConfig != null;
    }

    public JSONObject getAllConfig() {
        return this.jsonConfig;
    }

    public Map<String, Object> getConfig(int type) {
        HashMap<String, Object> conf = new HashMap<String, Object>(2);
        String savePath = null;
        switch (type) {
            case 4: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.jsonConfig.getLong("fileMaxSize"));
                conf.put("allowFiles", this.getArray("fileAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("fileFieldName"));
                savePath = this.jsonConfig.getString("filePathFormat");
                break;
            }
            case 1: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.jsonConfig.getLong("imageMaxSize"));
                conf.put("allowFiles", this.getArray("imageAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("imageFieldName"));
                savePath = this.jsonConfig.getString("imagePathFormat");
                break;
            }
            case 3: {
                conf.put("maxSize", this.jsonConfig.getLong("videoMaxSize"));
                conf.put("allowFiles", this.getArray("videoAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("videoFieldName"));
                savePath = this.jsonConfig.getString("videoPathFormat");
                break;
            }
            case 2: {
                conf.put("filename", SCRAWL_FILE_NAME);
                conf.put("maxSize", this.jsonConfig.getLong("scrawlMaxSize"));
                conf.put("fieldName", this.jsonConfig.getString("scrawlFieldName"));
                conf.put("isBase64", "true");
                savePath = this.jsonConfig.getString("scrawlPathFormat");
                break;
            }
            case 5: {
                conf.put("filename", REMOTE_FILE_NAME);
                conf.put("filter", this.getArray("catcherLocalDomain"));
                conf.put("maxSize", this.jsonConfig.getLong("catcherMaxSize"));
                conf.put("allowFiles", this.getArray("catcherAllowFiles"));
                conf.put("fieldName", this.jsonConfig.getString("catcherFieldName") + "[]");
                savePath = this.jsonConfig.getString("catcherPathFormat");
                break;
            }
            case 7: {
                conf.put("allowFiles", this.getArray("imageManagerAllowFiles"));
                conf.put("dir", this.jsonConfig.getString("imageManagerListPath"));
                conf.put("count", this.jsonConfig.getIntValue("imageManagerListSize"));
                break;
            }
            case 6: {
                conf.put("allowFiles", this.getArray("fileManagerAllowFiles"));
                conf.put("dir", this.jsonConfig.getString("fileManagerListPath"));
                conf.put("count", this.jsonConfig.getIntValue("fileManagerListSize"));
                break;
            }
        }
        conf.put("savePath", savePath);
        conf.put("rootPath", this.rootPath);
        return conf;
    }

    public static String getRootPath(HttpServletRequest request, Map<String, Object> conf) {
        Object rootPath = request.getAttribute("rootPath");
        if (rootPath != null) {
            return rootPath + "" + File.separatorChar;
        }
        return conf.get("rootPath") + "";
    }

    private void initEnv() throws IOException {
        File file = new File(this.originalPath);
        if (!file.isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        if (this.parentPath == null) {
            this.parentPath = file.getParent();
        }
        String configContent = this.readFile(this.getConfigPath());
        try {
            JSONObject jsonConfig;
            this.jsonConfig = jsonConfig = JSON.parseObject((String)configContent);
        }
        catch (Exception e) {
            this.jsonConfig = null;
        }
    }

    private String getConfigPath() {
        String path = this.jsonConfigFilePath;
        if (new File(path).exists()) {
            return path;
        }
        return this.parentPath + File.separator + CONFIG_FILE_NAME;
    }

    private String[] getArray(String key) {
        JSONArray jsonArray = this.jsonConfig.getJSONArray(key);
        String[] result = new String[jsonArray.size()];
        int len = jsonArray.size();
        for (int i = 0; i < len; ++i) {
            result[i] = jsonArray.getString(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String path) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = null;
        BufferedReader bfReader = null;
        try {
            String tmpContent;
            reader = new InputStreamReader(new FileInputStream(path));
            bfReader = new BufferedReader(reader);
            while ((tmpContent = bfReader.readLine()) != null) {
                builder.append(tmpContent);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        finally {
            if (bfReader != null) {
                bfReader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return this.filter(builder.toString());
    }

    private String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }
}

