/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.multipartFile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class InputStreamToMultipartFile
implements MultipartFile {
    private String originalFilename;
    private String contentType;
    private final byte[] content;

    public InputStreamToMultipartFile(String originalFilename, String contentType, byte[] content) {
        this.originalFilename = originalFilename != null ? originalFilename : "";
        this.contentType = contentType;
        this.content = content != null ? content : new byte[]{};
    }

    public InputStreamToMultipartFile(String originalFilename, String contentType, InputStream contentStream) throws IOException {
        this(originalFilename, contentType, FileCopyUtils.copyToByteArray((InputStream)contentStream));
    }

    public String getName() {
        return this.originalFilename;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        FileCopyUtils.copy((byte[])this.content, (File)dest);
    }

    public static MultipartFile inputStreamConvert(String originalFilename, String contentType, byte[] content) {
        return new InputStreamToMultipartFile(originalFilename, contentType, content);
    }

    public static MultipartFile inputStreamConvert(String originalFilename, String contentType, InputStream contentStream) throws IOException {
        return new InputStreamToMultipartFile(originalFilename, contentType, contentStream);
    }
}

