/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.multipartFile;

import cn.chiship.sdk.core.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class Base64ToMultipartFile
implements MultipartFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64ToMultipartFile.class);
    private Random random = new Random();
    private final byte[] imgContent;
    private final String header;

    public Base64ToMultipartFile(byte[] imgContent, String header) {
        this.imgContent = imgContent;
        this.header = header.split(";")[0];
    }

    public String getName() {
        return (double)System.currentTimeMillis() + Math.random() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return System.currentTimeMillis() + (long)(this.random.nextInt() * 10000) + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File dest) {
        try (FileOutputStream fos = new FileOutputStream(dest);){
            fos.write(this.imgContent);
        }
        catch (IOException e) {
            LOGGER.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    public static MultipartFile base64Convert(String base64) {
        String[] baseStr = base64.split(",");
        byte[] b = Base64Util.decode((String)baseStr[1]);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        return new Base64ToMultipartFile(b, baseStr[0]);
    }
}

