/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.base;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.base.ProgressResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;
import cn.chiship.sdk.core.enums.ProgressResultEnum;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.id.SnowflakeIdUtil;
import cn.chiship.sdk.core.util.ClassUtil;
import cn.chiship.sdk.core.util.OutUtil;
import cn.chiship.sdk.core.util.RandomUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.base.BaseMapper;
import cn.chiship.sdk.framework.base.BaseService;
import cn.chiship.sdk.framework.pojo.vo.PageVo;
import cn.chiship.sdk.framework.properties.CommonConstantsConfigProperties;
import cn.chiship.sdk.framework.util.ExportUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

public abstract class BaseServiceImpl<Record, Example>
implements BaseService<Record, Example> {
    @Autowired
    private BaseMapper<Record, Example> baseMapper;
    public ConcurrentHashMap<String, ProgressResult> processStatusHm = new ConcurrentHashMap();

    @Override
    public BaseResult insertSelective(Record record) {
        try {
            boolean flag;
            Class<?> clazz = record.getClass();
            Field id = clazz.getDeclaredField("id");
            String getId = "getId";
            String longs = "Long";
            String uuid = "UUID";
            String snowflake = "SNOWFLAKE";
            if (StringUtil.isNull((Object)clazz.getMethod(getId, new Class[0]).invoke(record, new Object[0]))) {
                if (longs.equals(id.getType().getSimpleName())) {
                    ClassUtil.setFieldValue(record, (String)"id", (Object)SnowflakeIdUtil.generateId());
                } else {
                    String tableKeyGenerator = CommonConstantsConfigProperties.getInstance().getTableKeyGenerator();
                    if (uuid.equals(tableKeyGenerator)) {
                        ClassUtil.setFieldValue(record, (String)"id", (Object)RandomUtil.uuidLowerCase());
                    }
                    if (snowflake.equals(tableKeyGenerator)) {
                        ClassUtil.setFieldValue(record, (String)"id", (Object)SnowflakeIdUtil.generateStrId());
                    }
                }
            }
            ClassUtil.setFieldValue(record, (String)"gmtCreated", (Object)System.currentTimeMillis());
            ClassUtil.setFieldValue(record, (String)"gmtModified", (Object)System.currentTimeMillis());
            ClassUtil.setFieldValue(record, (String)"isDeleted", (Object)0);
            boolean bl = flag = this.baseMapper.insertSelective(record) > 0;
            if (!flag) {
                return new BaseResult(Boolean.FALSE, BaseResultEnum.EXCEPTION_DATA_BASE_INSERT, null);
            }
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, record);
        }
        catch (Exception e) {
            throw new SystemErrorException(e.getCause());
        }
    }

    @Override
    public BaseResult deleteByExample(Example example) {
        try {
            this.baseMapper.deleteByExample(example);
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, null);
        }
        catch (Exception e) {
            throw new SystemErrorException(e.getCause());
        }
    }

    @Override
    public BaseResult deleteByPrimaryKey(Object id) {
        try {
            this.baseMapper.deleteByPrimaryKey(id);
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, null);
        }
        catch (Exception e) {
            throw new SystemErrorException(e.getCause());
        }
    }

    @Override
    public BaseResult updateByExampleSelective(Record record, Example example) {
        try {
            boolean flag;
            ClassUtil.setFieldValue(record, (String)"gmtModified", (Object)System.currentTimeMillis());
            boolean bl = flag = this.baseMapper.updateByExampleSelective(record, example) > 0;
            if (!flag) {
                return new BaseResult(Boolean.FALSE, BaseResultEnum.EXCEPTION_DATA_BASE_UPDATE, null);
            }
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, record);
        }
        catch (Exception e) {
            throw new SystemErrorException(e.getCause());
        }
    }

    @Override
    public BaseResult updateByPrimaryKeySelective(Record record) {
        try {
            boolean flag;
            ClassUtil.setFieldValue(record, (String)"gmtModified", (Object)System.currentTimeMillis());
            boolean bl = flag = this.baseMapper.updateByPrimaryKeySelective(record) > 0;
            if (!flag) {
                return new BaseResult(Boolean.FALSE, BaseResultEnum.EXCEPTION_DATA_BASE_UPDATE, null);
            }
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, record);
        }
        catch (Exception e) {
            throw new SystemErrorException(e.getCause());
        }
    }

    @Override
    public List<Record> selectByExample(Example example) {
        List<Record> records = this.baseMapper.selectByExample(example);
        return records;
    }

    @Override
    public Record selectByPrimaryKey(Object id) {
        Record record = this.baseMapper.selectByPrimaryKey(id);
        return record;
    }

    @Override
    public BaseResult selectDetailsByPrimaryKey(Object id) {
        return BaseResult.error((Object)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010selectDetailsByPrimaryKey\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e"));
    }

    @Override
    public long countByExample(Example example) {
        return this.baseMapper.countByExample(example);
    }

    @Override
    public PageVo selectPageByExample(PageVo pageVo, Example example) {
        String sort = pageVo.getSort();
        System.out.println("------------>" + sort);
        Page page = PageHelper.startPage((int)pageVo.getCurrent().intValue(), (int)pageVo.getSize().intValue());
        PageHelper.orderBy((String)sort);
        List<Record> records = this.baseMapper.selectByExample(example);
        pageVo.setRecords(records);
        pageVo.setTotal(page.getTotal());
        pageVo.setPages(Long.valueOf(page.getPages()));
        return pageVo;
    }

    @Override
    public void exportData(HttpServletResponse response, Map<String, Object> paramMap) throws Exception {
        OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.error((Object)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010exportData\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e")));
    }

    @Override
    @Async
    public void asyncExportData(HttpServletResponse response, String taskId, Map<String, Object> paramMap) {
        try {
            this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_PROGRESS_ENUM, (String)"40%"));
            Thread.sleep(3000L);
            this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_ERROR_ENUM, (String)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010asyncExportData\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e")));
        }
        catch (Exception e) {
            this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_ERROR_ENUM, (String)e.getLocalizedMessage()));
        }
    }

    @Override
    public void getExportProcessStatus(HttpServletResponse response, String taskId) throws Exception {
        ProgressResult progressResult = this.processStatusHm.get(taskId);
        if (StringUtil.isNull((Object)progressResult)) {
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.error((Object)("\u4f60\u5f00\u542f\u4e86\u5f02\u6b65\u5bfc\u51fa\uff0c\u786e\u5b9a\u8c03\u7528\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010asyncExportData\u3011\u4e86\u5417?")));
        } else if (progressResult.isFile()) {
            byte[] bytes = progressResult.getBytes();
            if (StringUtil.isNull((Object)bytes)) {
                this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_ERROR_ENUM, (String)"\u6807\u9898\u5217\u6570\u4e0e\u6570\u503c\u5217\u6570\u4e0d\u5339\u914d\u6216\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u683c\u5f0f\uff01"));
            } else {
                System.out.println("------------processStatusHM:" + this.processStatusHm.size());
                this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_FINISH_ENUM));
                System.out.println("\u6587\u4ef6\u5927\u5c0f:" + bytes.length);
                ExportUtil.getInstance().exportByType(response, progressResult.getExportType(), progressResult.getFileName(), bytes);
                Thread.sleep(2000L);
                this.processStatusHm.remove(taskId);
            }
        } else {
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.ok((Object)progressResult));
        }
    }

    @Override
    public void asyncImportData(InputStream inputStream, String taskId, Map<String, Object> paramMap) {
        try {
            this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_PROGRESS_ENUM, (String)"40%"));
            Thread.sleep(3000L);
            this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_ERROR_ENUM, (String)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010asyncImportData\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e")));
        }
        catch (Exception e) {
            this.processStatusHm.put(taskId, ProgressResult.out((ProgressResultEnum)ProgressResultEnum.PROGRESS_ERROR_ENUM, (String)e.getLocalizedMessage()));
        }
    }

    @Override
    public BaseResult getImportProcessStatus(String taskId) {
        ProgressResult progressResult = this.processStatusHm.get(taskId);
        if (StringUtil.isNull((Object)progressResult)) {
            return BaseResult.error((Object)("\u4f60\u5f00\u542f\u4e86\u5f02\u6b65\u5bfc\u5165\uff0c\u786e\u5b9a\u8c03\u7528\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010asyncExportData\u3011\u4e86\u5417?"));
        }
        return BaseResult.ok((Object)progressResult);
    }

    @Override
    public BaseResult validateExistByField(String id, String field, String value) {
        return BaseResult.error((Object)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010validateExistByField\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e"));
    }
}

