/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.base;

import cn.chiship.sdk.cache.service.UserCacheService;
import cn.chiship.sdk.cache.vo.CacheOrganizationVo;
import cn.chiship.sdk.cache.vo.CacheRoleVo;
import cn.chiship.sdk.cache.vo.CacheTenantVo;
import cn.chiship.sdk.cache.vo.CacheUserVO;
import cn.chiship.sdk.core.annotation.Authorization;
import cn.chiship.sdk.core.annotation.NoParamsSign;
import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.id.SnowflakeIdUtil;
import cn.chiship.sdk.core.util.ClassUtil;
import cn.chiship.sdk.core.util.DateUtils;
import cn.chiship.sdk.core.util.OutUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.base.BaseService;
import cn.chiship.sdk.framework.pojo.vo.OptionUser;
import cn.chiship.sdk.framework.pojo.vo.PageVo;
import cn.chiship.sdk.framework.util.BindingResultUtil;
import cn.chiship.sdk.framework.util.OptionUserUtil;
import cn.chiship.sdk.framework.util.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public abstract class BaseController<Record, Example> {
    @Autowired
    UserCacheService userCacheService;

    public abstract BaseService<Record, Example> getService();

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u5b57\u6bb5\u6821\u9a8c\u6570\u636e\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e", dataTypeClass=String.class, paramType="query"), @ApiImplicitParam(name="field", value="\u5b57\u6bb5", required=true, dataTypeClass=String.class, paramType="query"), @ApiImplicitParam(name="value", value="\u503c", required=true, dataTypeClass=String.class, paramType="query")})
    @Authorization
    @GetMapping(value={"validateExistByField"})
    public ResponseEntity<BaseResult> validateExistByField(@RequestParam(required=false, defaultValue="", value="id") String id, @RequestParam(value="field") String field, @RequestParam(value="value") String value) {
        return new ResponseEntity((Object)this.getService().validateExistByField(id, field, value), HttpStatus.OK);
    }

    @ApiOperation(value="\u3010\u5bfc\u51fa\u3011\u6307\u5b9a\u683c\u5f0f(exportType:csv\u3001xls\u3001xlsx\u3001json)\u7684\u6570\u636e\u6587\u4ef6\uff0c\u652f\u6301\u5f02\u6b65\u5bfc\u51fa(async=true)")
    @ApiImplicitParams(value={})
    @PostMapping(value={"exportData"})
    public void exportData(@RequestBody @Valid JSONObject paramsMap, HttpServletResponse response) throws Exception {
        String a = "exportType";
        if (!paramsMap.containsKey((Object)a)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570[" + a + "]");
        }
        String exportType = paramsMap.get((Object)a).toString();
        if (StringUtil.isNullOrEmpty((String)exportType)) {
            BaseResult baseResult = BaseResult.error((Object)("\u53c2\u6570[" + a + "]\u4e0d\u80fd\u4e3a\u7a7a"));
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
        }
        boolean async = false;
        String b = "async";
        if (paramsMap.containsKey((Object)b)) {
            async = paramsMap.getBoolean(b);
        }
        if (async) {
            String taskId = DateUtils.dateTimeNow() + SnowflakeIdUtil.generateId();
            this.getService().asyncExportData(response, taskId, (Map<String, Object>)paramsMap);
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.ok((Object)taskId));
        } else {
            this.getService().exportData(response, (Map<String, Object>)paramsMap);
        }
    }

    @ApiOperation(value="\u3010\u5bfc\u51fa\u3011\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5f02\u6b65\u5bfc\u51fa\u4efb\u52a1\u5b9e\u65f6\u8fdb\u5ea6(\u53ef\u5305\u88c5)")
    @ApiImplicitParams(value={})
    @PostMapping(value={"getExportProcessStatus"})
    public void getExportProcessStatus(HttpServletResponse response, @RequestBody @Valid Map<String, Object> paramsMap) throws Exception {
        String taskId = paramsMap.get("taskId").toString();
        if (StringUtil.isNullOrEmpty((String)taskId)) {
            BaseResult baseResult = BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u7f3a\u5c11\u53c2\u6570[taskId]");
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
        }
        this.getService().getExportProcessStatus(response, taskId);
    }

    @ApiOperation(value="\u3010\u5bfc\u5165\u3011\u5bfc\u5165Excel\u6216Csv\u6570\u636e(\u53ef\u5305\u88c5)")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/importData"})
    @NoParamsSign
    public ResponseEntity<BaseResult> importData(@RequestParam(value="file") MultipartFile multipartFile) throws Exception {
        if (multipartFile.isEmpty()) {
            return new ResponseEntity((Object)BaseResult.error((Object)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6"), HttpStatus.OK);
        }
        Map<String, Object> paramMap = ServletUtil.getParameterValues();
        paramMap.put("fileName", multipartFile.getOriginalFilename());
        paramMap.put("contentType", multipartFile.getContentType());
        paramMap.put("userVo", this.getLoginUser());
        InputStream is = multipartFile.getInputStream();
        String taskId = DateUtils.dateTimeNow() + SnowflakeIdUtil.generateId();
        this.getService().asyncImportData(is, taskId, paramMap);
        return new ResponseEntity((Object)BaseResult.ok((Object)taskId), HttpStatus.OK);
    }

    @ApiOperation(value="\u3010\u5bfc\u5165\u3011\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5f02\u6b65\u5bfc\u5165\u4efb\u52a1\u5b9e\u65f6\u8fdb\u5ea6(\u53ef\u5305\u88c5)")
    @PostMapping(value={"/getImportProcessStatus"})
    @ApiImplicitParams(value={})
    @NoParamsSign
    public ResponseEntity getImportProcessStatus(@RequestBody @Valid Map<String, Object> paramsMap) {
        String taskId = paramsMap.get("taskId").toString();
        if (StringUtil.isNullOrEmpty((String)taskId)) {
            return new ResponseEntity((Object)BaseResult.error((Object)"\u7f3a\u5c11\u53c2\u6570[taskId]"), HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.getService().getImportProcessStatus(taskId), HttpStatus.OK);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952eID", required=true, dataTypeClass=String.class, paramType="path")})
    @GetMapping(value={"getById/{id}"})
    public ResponseEntity<BaseResult> getById(@PathVariable(value="id") String id) {
        return new ResponseEntity((Object)BaseResult.ok(this.getService().selectByPrimaryKey(id)), HttpStatus.OK);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u8be6\u60c5\u6570\u636e(\u53ef\u5305\u88c5)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952eID", required=true, dataTypeClass=String.class, paramType="path")})
    @GetMapping(value={"getDetailsById/{id}"})
    public ResponseEntity<BaseResult> getDetailsById(@PathVariable(value="id") String id) {
        return new ResponseEntity((Object)this.getService().selectDetailsByPrimaryKey(id), HttpStatus.OK);
    }

    public PageVo page(Example example) {
        PageVo pageVo = ServletUtil.getPageVo();
        String sort = "-gmt_modified";
        return this.getService().selectPageByExample(pageVo, example);
    }

    public List<Record> list(Example example) {
        return this.getService().selectByExample(example);
    }

    public BaseResult save(Record record) {
        ClassUtil.setFieldValue(record, (String)"createdBy", (Object)OptionUserUtil.getCurrentOptionUser(this.getLoginUser()));
        ClassUtil.setFieldValue(record, (String)"userId", (Object)this.getUserId());
        try {
            CacheOrganizationVo cacheOrganizationVo = this.getLoginUserOrg();
            ClassUtil.setFieldValue(record, (String)"orgId", (Object)cacheOrganizationVo.getId());
            ClassUtil.setFieldValue(record, (String)"orgName", (Object)cacheOrganizationVo.getOrganizationName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getService().insertSelective(record);
    }

    public BaseResult update(Object id, Record record) {
        if (StringUtil.isNull((Object)id)) {
            return BaseResult.error((BaseResultEnum)BaseResultEnum.BUSINESS_ERROR, (Object)"\u53c2\u6570[id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ClassUtil.setFieldValue(record, (String)"id", (Object)id);
        ClassUtil.setFieldValue(record, (String)"modifyBy", (Object)OptionUserUtil.getCurrentOptionUser(this.getLoginUser()));
        return this.getService().updateByPrimaryKeySelective(record);
    }

    public BaseResult remove(Example example) {
        return this.getService().deleteByExample(example);
    }

    public BaseResult validParams(BindingResult bindingResult) {
        return BindingResultUtil.format(bindingResult);
    }

    protected Object getUserId() {
        return this.getLoginUser().getId();
    }

    protected String getUserName() {
        return this.getLoginUser().getUsername();
    }

    protected boolean hasRole(String role) {
        return this.hasRole(Collections.singletonList(role));
    }

    protected boolean hasRole(List<String> roles) {
        List<String> hasRoles = this.getRoles();
        return hasRoles.containsAll(roles);
    }

    protected Object getOrganizationId() {
        CacheOrganizationVo cacheOrganizationVo = this.getLoginUser().getCacheOrganizationVo();
        if (StringUtil.isNull((Object)cacheOrganizationVo)) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u7528\u6237\u6682\u65e0\u7ed1\u5b9a\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        return cacheOrganizationVo.getId();
    }

    protected CacheOrganizationVo getLoginUserOrg() {
        CacheOrganizationVo cacheOrganizationVo = this.getLoginUser().getCacheOrganizationVo();
        if (StringUtil.isNull((Object)cacheOrganizationVo)) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u7528\u6237\u6682\u65e0\u7ed1\u5b9a\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        return cacheOrganizationVo;
    }

    protected List<String> getRoles() {
        List roleVos = this.getLoginUser().getCacheRoleVos();
        ArrayList<String> roles = new ArrayList<String>();
        if (roleVos != null) {
            for (CacheRoleVo roleVo : roleVos) {
                roles.add(roleVo.getRoleCode());
            }
        }
        return roles;
    }

    protected CacheUserVO getLoginUser() {
        CacheUserVO cacheUserVO = this.userCacheService.getUser();
        if (StringUtil.isNull((Object)cacheUserVO)) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u5f97\u5f53\u524d\u767b\u9646\u7528\u6237,\u8bf7\u53cd\u9988\u81f3\u7ba1\u7406\u5458");
        }
        return cacheUserVO;
    }

    protected String getCurrentOptionUser() {
        return OptionUserUtil.getCurrentOptionUser(this.getLoginUser());
    }

    protected OptionUser getCurrentOptionUser(String optionUserStr) {
        return OptionUserUtil.getCurrentOptionUser(optionUserStr);
    }

    protected Boolean judgeTenant() {
        CacheTenantVo tenantVo = this.getLoginUser().getCacheTenantVo();
        return ObjectUtils.isNotEmpty((Object)tenantVo);
    }

    protected Object getTenantId() {
        if (this.judgeTenant().booleanValue()) {
            return this.getLoginUser().getCacheTenantVo().getId();
        }
        throw new BusinessException("\u5f53\u524d\u767b\u9646\u7528\u6237\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u79df\u6237\uff0c\u8bf7\u5148\u4f7f\u7528judgeTenant()\u5224\u65ad\u662f\u5426\u79df\u6237");
    }

    protected ResponseEntity<BaseResult> responseEntity(BaseResult baseResult) {
        return this.responseEntity(baseResult, HttpStatus.OK);
    }

    protected ResponseEntity<BaseResult> responseEntity(BaseResult baseResult, HttpStatus httpStatus) {
        return new ResponseEntity((Object)baseResult, httpStatus);
    }
}

