package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.enums.HeaderEnum;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.Base64Util;
import cn.chiship.sdk.core.util.FileUtil;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

/**
 * @author lijian
 */
public class File2Util extends FileUtil {
    /**
     * 读取文件
     *
     * @param file 文件
     * @return 结果
     */
    public static String readResourceFile(String file) {
        try {
            Resource resource = new ClassPathResource(file);
            InputStream is = resource.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s + "\n");
            }
            br.close();
            isr.close();
            is.close();
            return sb.toString();
        } catch (Exception e) {
            throw new SystemErrorException("读取文件错误" + file);
        }
    }

    /**
     * 读取文件
     *
     * @param file 文件
     * @return 结果
     */
    public static byte[] readResource(String file) {
        try {
            Resource resource = new ClassPathResource(file);
            InputStream is = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray(is);
            is.close();
            return bytes;
        } catch (Exception e) {
            throw new SystemErrorException("读取文件错误" + file);
        }
    }

    /**
     * 下载文件名重新编码
     *
     * @param response     响应对象
     * @param realFileName 真实文件名
     */
    public static void setAttachmentResponseHeader(HttpServletResponse response, String realFileName) {
        String percentEncodedFileName = percentEncode(realFileName);

        StringBuilder contentDispositionValue = new StringBuilder();
        contentDispositionValue.append("attachment; filename=")
                .append(percentEncodedFileName)
                .append(";")
                .append("filename*=")
                .append("utf-8''")
                .append(percentEncodedFileName);

        response.setHeader(HeaderEnum.HEADER_CONTENT_DISPOSITION.getName(), contentDispositionValue.toString());
        response.setHeader(HeaderEnum.HEADER_DOWNLOAD_FILENAME.getName(), percentEncodedFileName);
    }

    public static String percentEncode(String s) {
        String encode = Base64Util.encode(s.getBytes());
        return encode.replaceAll("\\+", "%20");
    }


}
