package cn.chiship.sdk.framework.ue;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author lj
 */
public class PathFormat {
    private static final String TIME="time";
    private static final String YYYY="yyyy";
    private static final String YY="yy";
    private static final String MM="mm";
    private static final String DD="dd";
    private static final String HH="hh";
    private static final String II="ii";
    private static final String SS="ss";

    static Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}", 2);
    private static Date currentDate = null;

    private PathFormat() {
    }

    public static String parse(String input) {
        Matcher matcher = pattern.matcher(input);
        currentDate = new Date();
        StringBuffer sb = new StringBuffer();

        while (matcher.find()) {
            matcher.appendReplacement(sb, getString(matcher.group(1)));
        }

        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String format(String input) {
        return input.replace("\\", "/");
    }

    public static String parse(String input, String filename) {
        Matcher matcher = pattern.matcher(input);
        String matchStr = null;
        currentDate = new Date();
        StringBuffer sb = new StringBuffer();

        while (matcher.find()) {
            matchStr = matcher.group(1);
            if (matchStr.indexOf("filename") != -1) {
                filename = filename.replace("$", "\\$").replaceAll("[\\/:*?\"<>|]", "");
                matcher.appendReplacement(sb, filename);
            } else {
                matcher.appendReplacement(sb, getString(matchStr));
            }
        }

        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getString(String pattern) {
        pattern = pattern.toLowerCase();
        if (pattern.indexOf(TIME) != -1) {
            return getTimestamp();
        } else if (pattern.indexOf(YYYY) != -1) {
            return getFullYear();
        } else if (pattern.indexOf(YY) != -1) {
            return getYear();
        } else if (pattern.indexOf(MM) != -1) {
            return getMonth();
        } else if (pattern.indexOf(DD) != -1) {
            return getDay();
        } else if (pattern.indexOf(HH) != -1) {
            return getHour();
        } else if (pattern.indexOf(II) != -1) {
            return getMinute();
        } else if (pattern.indexOf(SS) != -1) {
            return getSecond();
        } else {
            return pattern.indexOf("rand") != -1 ? getRandom(pattern) : pattern;
        }
    }

    private static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    private static String getFullYear() {
        return (new SimpleDateFormat("yyyy")).format(currentDate);
    }

    private static String getYear() {
        return (new SimpleDateFormat("yy")).format(currentDate);
    }

    private static String getMonth() {
        return (new SimpleDateFormat("MM")).format(currentDate);
    }

    private static String getDay() {
        return (new SimpleDateFormat("dd")).format(currentDate);
    }

    private static String getHour() {
        return (new SimpleDateFormat("HH")).format(currentDate);
    }

    private static String getMinute() {
        return (new SimpleDateFormat("mm")).format(currentDate);
    }

    private static String getSecond() {
        return (new SimpleDateFormat("ss")).format(currentDate);
    }

    private static String getRandom(String pattern) {
        pattern = pattern.split(":")[1].trim();
        int length = Integer.parseInt(pattern);
        return String.valueOf(Math.random()).replace(".", "").substring(0, length);
    }
}
