package cn.chiship.sdk.framework.base;


import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.framework.pojo.vo.PageVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * @author lj
 * 2018-05-17
 */
public interface BaseService<Record, Example> {

    /**
     * 插入记录有效字段
     *
     * @param record 插入数据的实体
     * @return 结果
     */
    BaseResult insertSelective(Record record);

    /**
     * 根据条件删除记录
     *
     * @param example 删除记录条件
     * @return 结果
     */
    BaseResult deleteByExample(Example example);

    /**
     * 根据主键删除记录
     *
     * @param id 主键
     * @return 结果
     */
    BaseResult deleteByPrimaryKey(Object id);

    /**
     * 根据条件更新有效字段
     *
     * @param record  实体
     * @param example 条件
     * @return 结果
     */
    BaseResult updateByExampleSelective(Record record, Example example);


    /**
     * 根据主键更新记录有效字段
     *
     * @param record 实体
     * @return 结果
     */
    BaseResult updateByPrimaryKeySelective(Record record);


    /**
     * 根据条件查询记录
     *
     * @param example 条件
     * @return 结果
     */
    List<Record> selectByExample(Example example);


    /**
     * 根据主键查询记录
     *
     * @param id 主键
     * @return 结果
     */
    Record selectByPrimaryKey(Object id);

    /**
     * 根据主键查找记录详情
     *
     * @param id 主键
     * @return 结果
     */
    BaseResult selectDetailsByPrimaryKey(Object id);

    /**
     * 根据条件查询记录数量
     *
     * @param example 条件
     * @return 结果
     */
    long countByExample(Example example);


    /**
     * 分页
     *
     * @param pageVo  分页对象
     * @param example 条件
     * @return 结果
     */
    PageVo selectPageByExample(PageVo pageVo, Example example);

    /**
     * 导出
     *
     * @param response 响应
     * @param paramMap 参数集合
     * @throws Exception 异常
     */
    void exportData(HttpServletResponse response, Map<String, Object> paramMap) throws Exception;

    /**
     * 异步导出
     *
     * @param response 响应
     * @param taskId   任务ID
     * @param paramMap 参数集合
     */
    void asyncExportData(HttpServletResponse response, String taskId, Map<String, Object> paramMap);

    /**
     * 异步导入数据
     *
     * @param inputStream
     * @param taskId
     * @param paramMap
     */
    void asyncImportData(InputStream inputStream, String taskId, Map<String, Object> paramMap);


    /**
     * 获得导出实时进度
     *
     * @param response
     * @param taskId
     * @throws Exception
     */
    void getExportProcessStatus(HttpServletResponse response, String taskId) throws Exception;

    /**
     * 获得数据导入实时进度
     *
     * @param taskId 任务ID
     * @return 进度
     */
    BaseResult getImportProcessStatus(String taskId);

    /**
     * 根据字段校验数据是否存在
     *
     * @param id    主键
     * @param field 字段名
     * @param value 字段值
     * @return 结果
     */
    BaseResult validateExistByField(String id, String field, String value);
}
