/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.velocity;

import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private VelocityUtil() {
    }

    public static void generate(String inputVmFilePath, String outputFilePath, VelocityContext context) {
        try {
            Properties properties = new Properties();
            properties.setProperty("file.resource.loader.path", VelocityUtil.getPath(inputVmFilePath));
            Velocity.init((Properties)properties);
            Template template = Velocity.getTemplate((String)VelocityUtil.getFile(inputVmFilePath), (String)"UTF-8");
            File outputFile = new File(outputFilePath);
            FileWriterWithEncoding writer = new FileWriterWithEncoding(outputFile, "UTF-8");
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
        catch (Exception ex) {
            throw new SystemErrorException((Throwable)ex);
        }
    }

    public static String generate(String inputVmFilePath, VelocityContext context) {
        try {
            Properties properties = new Properties();
            properties.setProperty("file.resource.loader.path", VelocityUtil.getPath(inputVmFilePath));
            Velocity.init((Properties)properties);
            Template template = Velocity.getTemplate((String)VelocityUtil.getFile(inputVmFilePath), (String)"utf-8");
            StringWriter writer = new StringWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (Exception ex) {
            throw new SystemErrorException((Throwable)ex);
        }
    }

    public static String getPath(String filePath) {
        String path = "";
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            path = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        return path;
    }

    public static String getFile(String filePath) {
        String file = "";
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            file = filePath.substring(filePath.lastIndexOf("/") + 1);
        }
        return file;
    }
}

