/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.enums.ContentTypeEnum;
import cn.chiship.sdk.core.enums.FileExtEnum;
import cn.chiship.sdk.core.text.Convert;
import cn.chiship.sdk.core.util.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    private static final String[] AGENT = new String[]{"Android", "iPhone", "iPod", "iPad", "Windows Phone", "MQQBrowser"};

    public static String getHeader(String name) {
        return ServletUtil.getRequest().getHeader(name);
    }

    public static String getParameter(String name) {
        return ServletUtil.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return Convert.toStr((Object)ServletUtil.getRequest().getParameter(name), (String)defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return Convert.toInt((Object)ServletUtil.getRequest().getParameter(name));
    }

    public static Map<String, Object> getParameterValues() {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        Enumeration parameterNames = ServletUtil.getRequest().getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String value = ServletUtil.getRequest().getParameter(name);
            params.put(name, value);
        }
        return params;
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return Convert.toInt((Object)ServletUtil.getRequest().getParameter(name), (Integer)defaultValue);
    }

    public static HttpServletRequest getRequest() {
        return ServletUtil.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtil.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtil.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf(ContentTypeEnum.APPLICATION_JSON.getName()) != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        String a = "XMLHttpRequest";
        if (xRequestedWith != null && xRequestedWith.indexOf(a) != -1) {
            return true;
        }
        String uri = request.getRequestURI();
        if (StringUtil.inStringIgnoreCase((String)uri, (String[])new String[]{FileExtEnum.FILE_EXT_JSON.getName(), FileExtEnum.FILE_EXT_XML.getName()})) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return StringUtil.inStringIgnoreCase((String)ajax, (String[])new String[]{"json", "xml"});
    }

    public static boolean checkAgentIsMobile(String ua) {
        boolean check;
        String winNt = "Windows NT";
        boolean flag = false;
        boolean bl = check = !ua.contains(winNt) || ua.contains(winNt) && ua.contains("compatible; MSIE 9.0;");
        if (check) {
            String a = "Macintosh";
            if (!ua.contains(winNt) && !ua.contains(a)) {
                for (String item : AGENT) {
                    if (!ua.contains(item)) continue;
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }
}

