/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.velocity;

import cn.chiship.sdk.core.util.JdbcUtil;
import cn.chiship.sdk.core.util.PlatformUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.velocity.VelocityUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.VelocityContext;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisGeneratorTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisGeneratorTools.class);
    private static String generatorConfigVm = "/template/generatorConfig.vm";
    private static String serviceVm = "/template/Service.vm";
    private static String serviceImplVm = "/template/ServiceImpl.vm";
    private static String controllerVm = "/template/Controller.vm";
    private static String dtoVm = "/template/Dto.vm";
    private static String webVueVm = "/template/Web.Vue.vm";
    private static String webServiceVm = "/template/Web.Service.vm";

    private MybatisGeneratorTools() {
    }

    public static void generator(String jdbcDriver, String jdbcUrl, String jdbcUsername, String jdbcPassword, String database, String tablePrefix, String packageName, Map<String, String> lastInsertIdTables) throws Exception {
        String basePath = MybatisGeneratorTools.class.getResource("/").getPath().replace("/target/classes/", "");
        if (!PlatformUtil.isLinux()) {
            generatorConfigVm = MybatisGeneratorTools.class.getResource(generatorConfigVm).getPath().replaceFirst("/", "");
            serviceVm = MybatisGeneratorTools.class.getResource(serviceVm).getPath().replaceFirst("/", "");
            serviceImplVm = MybatisGeneratorTools.class.getResource(serviceImplVm).getPath().replaceFirst("/", "");
            controllerVm = MybatisGeneratorTools.class.getResource(controllerVm).getPath().replaceFirst("/", "");
            dtoVm = MybatisGeneratorTools.class.getResource(dtoVm).getPath().replaceFirst("/", "");
            webVueVm = MybatisGeneratorTools.class.getResource(webVueVm).getPath().replaceFirst("/", "");
            webServiceVm = MybatisGeneratorTools.class.getResource(webServiceVm).getPath().replaceFirst("/", "");
            basePath = basePath.replaceFirst("/", "");
        } else {
            generatorConfigVm = MybatisGeneratorTools.class.getResource(generatorConfigVm).getPath();
            serviceVm = MybatisGeneratorTools.class.getResource(serviceVm).getPath();
            serviceImplVm = MybatisGeneratorTools.class.getResource(serviceImplVm).getPath();
            controllerVm = MybatisGeneratorTools.class.getResource(controllerVm).getPath();
            dtoVm = MybatisGeneratorTools.class.getResource(dtoVm).getPath();
            webVueVm = MybatisGeneratorTools.class.getResource(webVueVm).getPath();
            webServiceVm = MybatisGeneratorTools.class.getResource(webServiceVm).getPath();
        }
        String generatorConfigXml = MybatisGeneratorTools.class.getResource("/").getPath().replace("/target/classes/", "") + "/src/main/resources/generatorConfig.xml";
        MybatisGeneratorTools.deleteDir(new File(generatorConfigXml));
        LOGGER.info("========== \u5f00\u59cb\u751f\u6210generatorConfig.xml\u6587\u4ef6 ==========");
        ArrayList<Map<String, Object>> tables = new ArrayList<Map<String, Object>>();
        try {
            VelocityContext context = new VelocityContext();
            JdbcUtil jdbcUtil = new JdbcUtil(jdbcDriver, jdbcUrl, jdbcUsername, jdbcPassword);
            List result = jdbcUtil.selectTablesByDatabase(database, tablePrefix);
            jdbcUtil.release();
            for (Map map : result) {
                String tableName = StringUtil.getString(map.get("name"));
                String tableComment = StringUtil.getString(map.get("comment"));
                LOGGER.info(tableName);
                HashMap<String, Object> table = new HashMap<String, Object>(2);
                table.put("table_name", tableName);
                table.put("table_comment", tableComment);
                table.put("model_name", StringUtil.lineToHump((String)tableName));
                if (!StringUtil.isNullOrEmpty((String)tableName)) {
                    JdbcUtil jdbcUtilCol = new JdbcUtil(jdbcDriver, jdbcUrl, jdbcUsername, jdbcPassword);
                    List columnResults = jdbcUtilCol.selectColumnsByTable(database, tableName);
                    jdbcUtilCol.release();
                    LinkedList<JSONObject> columns = new LinkedList<JSONObject>();
                    for (Map item : columnResults) {
                        String columnName = StringUtil.getString(item.get("column_name"));
                        String columnComment = StringUtil.getString(item.get("column_comment"));
                        JSONObject columnJson = new JSONObject();
                        columnJson.put("name", (Object)StringUtil.toLowerCaseFirstOne((String)StringUtil.lineToHump((String)columnName)));
                        columnJson.put("comment", (Object)StringUtil.toLowerCaseFirstOne((String)StringUtil.lineToHump((String)columnComment)));
                        columns.add(columnJson);
                    }
                    table.put("columns", columns);
                    jdbcUtilCol.release();
                }
                tables.add(table);
            }
            jdbcUtil.release();
            String targetProject = basePath;
            String targetProjectSqlMap = basePath;
            context.put("tables", tables);
            context.put("generator_javaModelGenerator_targetPackage", (Object)(packageName + ".entity"));
            context.put("generator_sqlMapGenerator_targetPackage", (Object)(packageName + ".mapper"));
            context.put("generator_javaClientGenerator_targetPackage", (Object)(packageName + ".mapper"));
            context.put("targetProject", (Object)targetProject);
            context.put("targetProject_sqlMap", (Object)targetProjectSqlMap);
            context.put("generator_jdbc_password", (Object)jdbcPassword);
            context.put("last_insert_id_tables", lastInsertIdTables);
            VelocityUtil.generate(generatorConfigVm, generatorConfigXml, context);
            for (int i = 0; i < tables.size(); ++i) {
                String model = StringUtil.lineToHump((String)StringUtil.getString(((Map)tables.get(i)).get("table_name")));
                MybatisGeneratorTools.deleteDir(new File(targetProjectSqlMap + "/src/main/resources/" + packageName.replaceAll("\\.", "/") + "/mapper/" + model + "Mapper.xml"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info("========== \u7ed3\u675f\u751f\u6210generatorConfig.xml\u6587\u4ef6 ==========");
        LOGGER.info("========== \u5f00\u59cb\u8fd0\u884cMybatisGenerator ==========");
        ArrayList warnings = new ArrayList();
        File configFile = new File(generatorConfigXml);
        ConfigurationParser cp = new ConfigurationParser(warnings);
        Configuration config = cp.parseConfiguration(configFile);
        DefaultShellCallback callback = new DefaultShellCallback(true);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
        myBatisGenerator.generate(null);
        for (String warning : warnings) {
            LOGGER.info(warning);
        }
        LOGGER.info("========== \u7ed3\u675f\u8fd0\u884cMybatisGenerator ==========");
        String ctime = new SimpleDateFormat("yyyy/M/d").format(new Date());
        MybatisGeneratorTools.generatorServices(basePath, packageName, tables, ctime);
        MybatisGeneratorTools.generatorController(basePath, packageName, tables, ctime);
        MybatisGeneratorTools.generatorDto(basePath, packageName, tables, ctime);
        MybatisGeneratorTools.generatorVue(basePath, packageName, tables, ctime);
    }

    private static void generatorServices(String basePath, String packageName, List<Map<String, Object>> tables, String ctime) throws Exception {
        LOGGER.info("========== \u5f00\u59cb\u751f\u6210Service ==========");
        String servicePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/service";
        String serviceImplPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/service/impl";
        FileUtils.forceMkdir((File)new File(servicePath));
        FileUtils.forceMkdir((File)new File(serviceImplPath));
        for (int i = 0; i < tables.size(); ++i) {
            File serviceImplFile;
            String model = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_comment")));
            String service = servicePath + "/" + model + "Service.java";
            String serviceImpl = serviceImplPath + "/" + model + "ServiceImpl.java";
            VelocityContext context = MybatisGeneratorTools.commonContext(packageName, model, modelName, ctime);
            File serviceFile = new File(service);
            if (!serviceFile.exists()) {
                VelocityUtil.generate(serviceVm, service, context);
                LOGGER.info("service\u8def\u5f84\uff1a{}", (Object)service);
            }
            if ((serviceImplFile = new File(serviceImpl)).exists()) continue;
            context.put("mapper", (Object)StringUtil.toLowerCaseFirstOne((String)model));
            VelocityUtil.generate(serviceImplVm, serviceImpl, context);
            LOGGER.info("serviceImpl\u8def\u5f84\uff1a{}", (Object)serviceImpl);
        }
        LOGGER.info("========== \u7ed3\u675f\u751f\u6210Service ==========");
    }

    private static void generatorController(String basePath, String packageName, List<Map<String, Object>> tables, String ctime) throws Exception {
        LOGGER.info("========== \u5f00\u59cb\u751f\u6210Controller ==========");
        String controllerPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/controller";
        FileUtils.forceMkdir((File)new File(controllerPath));
        for (int i = 0; i < tables.size(); ++i) {
            String model = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_comment")));
            String controller = controllerPath + "/" + model + "Controller.java";
            VelocityContext context = MybatisGeneratorTools.commonContext(packageName, model, modelName, ctime);
            File serviceFile = new File(controller);
            if (serviceFile.exists()) continue;
            VelocityUtil.generate(controllerVm, controller, context);
            LOGGER.info("controller\u8def\u5f84\uff1a{}", (Object)controller);
        }
        LOGGER.info("========== \u7ed3\u675f\u751f\u6210Controller ==========");
    }

    private static void generatorDto(String basePath, String packageName, List<Map<String, Object>> tables, String ctime) throws Exception {
        LOGGER.info("========== \u5f00\u59cb\u751f\u6210Dto ==========");
        String dtoPath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/pojo/dto";
        FileUtils.forceMkdir((File)new File(dtoPath));
        for (int i = 0; i < tables.size(); ++i) {
            String model = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_comment")));
            String dto = dtoPath + "/" + model + "Dto.java";
            VelocityContext context = MybatisGeneratorTools.commonContext(packageName, model, modelName, ctime);
            File dtoFile = new File(dto);
            if (dtoFile.exists()) continue;
            VelocityUtil.generate(dtoVm, dto, context);
            LOGGER.info("dto\u8def\u5f84\uff1a{}", (Object)dto);
        }
        LOGGER.info("========== \u7ed3\u675f\u751f\u6210Dto ==========");
    }

    private static void generatorVue(String basePath, String packageName, List<Map<String, Object>> tables, String ctime) throws Exception {
        LOGGER.info("========== \u5f00\u59cb\u751f\u6210Vue\u76f8\u5173 ==========");
        String webVuePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/vue/vue";
        String webServicePath = basePath + "/src/main/java/" + packageName.replaceAll("\\.", "/") + "/vue/js";
        FileUtils.forceMkdir((File)new File(webVuePath));
        FileUtils.forceMkdir((File)new File(webServicePath));
        for (int i = 0; i < tables.size(); ++i) {
            String vueService;
            File webServiceFile;
            String model = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_name")));
            String modelName = StringUtil.lineToHump((String)StringUtil.getString((Object)tables.get(i).get("table_comment")));
            List columns = (List)tables.get(i).get("columns");
            LOGGER.info(JSON.toJSONString((Object)columns));
            VelocityContext context = MybatisGeneratorTools.commonContext(packageName, model, modelName, ctime);
            context.put("columns", (Object)columns);
            String vue = webVuePath + "/" + StringUtil.toLowerCaseFirstOne((String)model) + ".vue";
            File webVueFile = new File(vue);
            if (!webVueFile.exists()) {
                VelocityUtil.generate(webVueVm, vue, context);
                LOGGER.info("vue\u8def\u5f84\uff1a{}", (Object)vue);
            }
            if ((webServiceFile = new File(vueService = webServicePath + "/" + model + "Service.js")).exists()) continue;
            VelocityUtil.generate(webServiceVm, vueService, context);
            LOGGER.info("vueService\u8def\u5f84:{}", (Object)vueService);
        }
        LOGGER.info("========== \u7ed3\u675f\u751f\u6210Vue\u76f8\u5173 ==========");
    }

    private static VelocityContext commonContext(String packageName, String model, String modelName, String ctime) {
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)packageName);
        context.put("ClassName", (Object)model);
        context.put("className", (Object)StringUtil.toLowerCaseFirstOne((String)model));
        context.put("ctime", (Object)ctime);
        context.put("modelName", (Object)modelName);
        return context;
    }

    public static void deleteDir(File dir) {
        LOGGER.error("\u5220\u9664\u8def\u5f84\uff1a{}", (Object)dir.getPath());
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                MybatisGeneratorTools.deleteDir(files[i]);
            }
        }
        if (!dir.delete()) {
            LOGGER.error("\u5220\u9664\u5931\u8d25:{]", (Object)dir.getAbsolutePath());
        }
    }
}

