/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.util.CsvUtils;
import cn.chiship.sdk.core.util.ExcelUtil;
import cn.chiship.sdk.core.util.OutUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ExportUtil {
    private static ExportUtil exportUtil;

    private ExportUtil() {
    }

    public static synchronized ExportUtil getInstance() {
        if (exportUtil == null) {
            exportUtil = new ExportUtil();
        }
        return exportUtil;
    }

    public byte[] getExportBytesByType(String exportType, String fileName, String sheetName, List<String> labels, List<List<String>> valueList) throws Exception {
        byte[] bytes;
        if (labels.size() != valueList.get(0).size()) {
            return new byte[0];
        }
        labels.add(0, "\u5e8f\u53f7");
        AtomicInteger index = new AtomicInteger(1);
        valueList.forEach(item -> item.add(0, String.valueOf(index.getAndIncrement())));
        switch (exportType) {
            case "xls": 
            case "xlsx": {
                bytes = ExcelUtil.getWriteExcelBytes((String)fileName, (String)sheetName, labels, valueList);
                break;
            }
            case "csv": {
                bytes = CsvUtils.getWriteCsvBytes(labels, valueList);
                break;
            }
            case "json": {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < valueList.size(); ++i) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    for (int j = 0; j < labels.size(); ++j) {
                        map.put(labels.get(j), valueList.get(i).get(j));
                    }
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(map));
                    jsonArray.add((Object)jsonObject);
                }
                bytes = jsonArray.toString().getBytes(StandardCharsets.UTF_8);
                break;
            }
            case "txt": {
                StringBuilder write = new StringBuilder();
                String doubleTab = "        ";
                String enter = "\r\n";
                for (String string : labels) {
                    write.append(string).append(doubleTab);
                }
                write.append(enter);
                for (List list : valueList) {
                    for (String val : list) {
                        write.append(val).append(doubleTab);
                    }
                    write.append(enter);
                }
                bytes = write.toString().getBytes(StandardCharsets.UTF_8);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u8bc6\u522b\u7684\u5bfc\u51fa\u683c\u5f0f\uff1a" + exportType);
            }
        }
        return bytes;
    }

    public void exportByType(HttpServletResponse response, String exportType, String fileName, byte[] bytes) throws Exception {
        ServletOutputStream os = response.getOutputStream();
        switch (exportType) {
            case "xls": 
            case "xlsx": {
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-disposition", "attachment;filename=" + fileName + "." + exportType);
                break;
            }
            case "csv": {
                response.setContentType("application/ms-txt.numberformat:@;charset=GBK");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + "." + exportType);
                break;
            }
            case "json": {
                response.setContentType("text/plain;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + "." + exportType);
                break;
            }
            case "txt": {
                response.setContentType("text/plain");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName + "." + exportType);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u8bc6\u522b\u7684\u8f93\u51fa\u683c\u5f0f\uff1a" + exportType);
            }
        }
        os.write(bytes);
        os.flush();
        os.close();
    }

    public void exportByType(HttpServletResponse response, String exportType, String fileName, List<String> labels, List<List<String>> valueList) throws Exception {
        if (valueList.isEmpty()) {
            BaseResult baseResult = BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55!");
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
            return;
        }
        if (labels.size() != valueList.get(0).size()) {
            BaseResult baseResult = BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u6807\u9898\u5217\u6570\u4e0e\u6570\u503c\u5217\u6570\u4e0d\u5339\u914d!");
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
            return;
        }
        labels.add(0, "\u5e8f\u53f7");
        AtomicInteger index = new AtomicInteger(1);
        valueList.forEach(item -> item.add(0, String.valueOf(index.getAndIncrement())));
        switch (exportType) {
            case "xls": 
            case "xlsx": {
                this.exportExcel(fileName, labels, valueList, response, exportType);
                break;
            }
            case "csv": {
                this.exportCsv(fileName, labels, valueList, response, exportType);
                break;
            }
            case "json": {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < valueList.size(); ++i) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    for (int j = 0; j < labels.size(); ++j) {
                        map.put(labels.get(j), valueList.get(i).get(j));
                    }
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(map));
                    jsonArray.add((Object)jsonObject);
                }
                this.exportJson(fileName, jsonArray, response, exportType);
                break;
            }
            case "txt": {
                this.exportTxt(fileName, labels, valueList, response, exportType);
                break;
            }
            default: {
                BaseResult baseResult = BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u683c\u5f0f");
                OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
            }
        }
    }

    public void exportCsv(String fileName, List<String> columnLabel, List<List<String>> columnValue, HttpServletResponse response, String exportType) throws IOException {
        response.setContentType("application/ms-txt.numberformat:@;charset=GBK");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + "." + exportType);
        ServletOutputStream os = response.getOutputStream();
        CsvUtils.writeCsv((OutputStream)os, columnLabel, columnValue);
        os.flush();
        os.close();
    }

    public void exportJson(String fileName, JSONArray jsonArray, HttpServletResponse response, String exportType) throws IOException {
        response.setContentType("text/plain;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + "." + exportType);
        ServletOutputStream os = response.getOutputStream();
        os.write(jsonArray.toString().getBytes(StandardCharsets.UTF_8));
        os.flush();
        os.close();
    }

    public void exportTxt(String fileName, List<String> columnLabel, List<List<String>> columnValue, HttpServletResponse response, String exportType) throws IOException {
        StringBuilder write = new StringBuilder();
        String doubleTab = "        ";
        String enter = "\r\n";
        for (String string : columnLabel) {
            write.append(string).append(doubleTab);
        }
        write.append(enter);
        for (List list : columnValue) {
            for (String val : list) {
                write.append(val).append(doubleTab);
            }
            write.append(enter);
        }
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + "." + exportType);
        BufferedOutputStream buff = new BufferedOutputStream((OutputStream)response.getOutputStream());
        buff.write(write.toString().getBytes(StandardCharsets.UTF_8));
        buff.flush();
        buff.close();
    }

    public void exportExcel(String fileName, List<String> headerNames, List<List<String>> values, HttpServletResponse response, String exportType) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        ServletOutputStream os = response.getOutputStream();
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + "." + exportType);
        ExcelUtil.writeExcel((OutputStream)os, (String)fileName, (String)fileName, headerNames, values);
        os.flush();
        os.close();
    }
}

