/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.springframework.web.multipart.MultipartFile;

public class Base64DecodeMultipartFile
implements MultipartFile {
    private Random random = new Random();
    private final byte[] imgContent;
    private final String header;

    public Base64DecodeMultipartFile(byte[] imgContent, String header) {
        this.imgContent = imgContent;
        this.header = header.split(";")[0];
    }

    public String getName() {
        return (double)System.currentTimeMillis() + Math.random() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return System.currentTimeMillis() + (long)(this.random.nextInt() * 10000) + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        new FileOutputStream(dest).write(this.imgContent);
    }

    public static MultipartFile base64Convert(String base64) {
        String[] baseStr = base64.split(",");
        byte[] b = Base64Util.decode((String)baseStr[1]);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        return new Base64DecodeMultipartFile(b, baseStr[0]);
    }
}

