/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.ue;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathFormat {
    private static final String TIME = "time";
    private static final String YYYY = "yyyy";
    private static final String YY = "yy";
    private static final String MM = "mm";
    private static final String DD = "dd";
    private static final String HH = "hh";
    private static final String II = "ii";
    private static final String SS = "ss";
    static Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}", 2);
    private static Date currentDate = null;

    private PathFormat() {
    }

    public static String parse(String input) {
        Matcher matcher = pattern.matcher(input);
        currentDate = new Date();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, PathFormat.getString(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String format(String input) {
        return input.replace("\\", "/");
    }

    public static String parse(String input, String filename) {
        Matcher matcher = pattern.matcher(input);
        String matchStr = null;
        currentDate = new Date();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matchStr = matcher.group(1);
            if (matchStr.indexOf("filename") != -1) {
                filename = filename.replace("$", "\\$").replaceAll("[\\/:*?\"<>|]", "");
                matcher.appendReplacement(sb, filename);
                continue;
            }
            matcher.appendReplacement(sb, PathFormat.getString(matchStr));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getString(String pattern) {
        if ((pattern = pattern.toLowerCase()).indexOf(TIME) != -1) {
            return PathFormat.getTimestamp();
        }
        if (pattern.indexOf(YYYY) != -1) {
            return PathFormat.getFullYear();
        }
        if (pattern.indexOf(YY) != -1) {
            return PathFormat.getYear();
        }
        if (pattern.indexOf(MM) != -1) {
            return PathFormat.getMonth();
        }
        if (pattern.indexOf(DD) != -1) {
            return PathFormat.getDay();
        }
        if (pattern.indexOf(HH) != -1) {
            return PathFormat.getHour();
        }
        if (pattern.indexOf(II) != -1) {
            return PathFormat.getMinute();
        }
        if (pattern.indexOf(SS) != -1) {
            return PathFormat.getSecond();
        }
        return pattern.indexOf("rand") != -1 ? PathFormat.getRandom(pattern) : pattern;
    }

    private static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    private static String getFullYear() {
        return new SimpleDateFormat(YYYY).format(currentDate);
    }

    private static String getYear() {
        return new SimpleDateFormat(YY).format(currentDate);
    }

    private static String getMonth() {
        return new SimpleDateFormat("MM").format(currentDate);
    }

    private static String getDay() {
        return new SimpleDateFormat(DD).format(currentDate);
    }

    private static String getHour() {
        return new SimpleDateFormat("HH").format(currentDate);
    }

    private static String getMinute() {
        return new SimpleDateFormat(MM).format(currentDate);
    }

    private static String getSecond() {
        return new SimpleDateFormat(SS).format(currentDate);
    }

    private static String getRandom(String pattern) {
        pattern = pattern.split(":")[1].trim();
        int length = Integer.parseInt(pattern);
        return String.valueOf(Math.random()).replace(".", "").substring(0, length);
    }
}

