/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.ue;

import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.ue.ConfigManager;
import cn.chiship.sdk.framework.ue.define.ActionMap;
import cn.chiship.sdk.framework.ue.define.BaseState;
import cn.chiship.sdk.framework.ue.define.State;
import cn.chiship.sdk.framework.ue.hunter.FileManager;
import cn.chiship.sdk.framework.ue.hunter.ImageHunter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ActionEnter {
    private HttpServletRequest request = null;
    private String rootPath = null;
    private String contextPath = null;
    private String actionType = null;
    private ConfigManager configManager = null;

    public ActionEnter(HttpServletRequest request, String rootPath, String jsonFilePath) {
        this.request = request;
        this.rootPath = rootPath;
        this.actionType = request.getParameter("action");
        this.contextPath = request.getContextPath();
        this.configManager = ConfigManager.getInstance(this.rootPath, jsonFilePath, this.contextPath, request.getRequestURI().replace(request.getContextPath(), ""));
    }

    public String exec() {
        String callbackName = this.request.getParameter("callback");
        if (callbackName != null) {
            if (!this.validCallbackName(callbackName)) {
                return new BaseState(false, 401).toJsonString();
            }
            return callbackName + "(" + this.invoke() + ");";
        }
        return this.invoke();
    }

    public String invoke() {
        if (this.actionType == null || !ActionMap.MAPPING.containsKey(this.actionType)) {
            return new BaseState(false, 101).toJsonString();
        }
        if (this.configManager == null || !this.configManager.valid()) {
            return new BaseState(false, 102).toJsonString();
        }
        State state = null;
        int actionCode = ActionMap.getType(this.actionType);
        switch (actionCode) {
            case 0: {
                return this.configManager.getAllConfig().toString();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Map<String, Object> conf = this.configManager.getConfig(actionCode);
                break;
            }
            case 5: {
                Map<String, Object> conf = this.configManager.getConfig(actionCode);
                String[] list = this.request.getParameterValues((String)conf.get("fieldName"));
                state = new ImageHunter(conf).capture(list);
                break;
            }
            case 6: 
            case 7: {
                Map<String, Object> conf = this.configManager.getConfig(actionCode);
                int start = this.getStartIndex();
                state = new FileManager(conf).listFile(start);
                break;
            }
        }
        if (StringUtil.isNull(state)) {
            return "";
        }
        return state.toJsonString();
    }

    public int getStartIndex() {
        String start = this.request.getParameter("start");
        try {
            return Integer.parseInt(start);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean validCallbackName(String name) {
        String a = "^[a-zA-Z_]+[\\w0-9_]*$";
        return name.matches(a);
    }
}

