/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.mybatis.plugin;

import cn.chiship.sdk.core.util.DateUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;

public class CommentGenerator
extends DefaultCommentGenerator {
    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String remarks = introspectedTable.getRemarks();
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" * " + remarks + "\u5b9e\u4f53");
        topLevelClass.addJavaDocLine(" *");
        topLevelClass.addJavaDocLine(this.genAuthorComment());
        topLevelClass.addJavaDocLine(this.genDateComment());
        topLevelClass.addJavaDocLine(" */");
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        super.addFieldComment(field, introspectedTable, introspectedColumn);
        if (introspectedColumn.getRemarks() != null && !"".equals(introspectedColumn.getRemarks())) {
            field.addJavaDocLine("/**");
            field.addJavaDocLine(" * " + introspectedColumn.getRemarks());
            field.addJavaDocLine(" */");
        }
    }

    private String genAuthorComment() {
        return " * @author " + System.getProperties().getProperty("user.name");
    }

    private String genDateComment() {
        return " * @date " + DateUtils.getDate();
    }
}

