/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.exception.cutom;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.model.CommonExceptionVo;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.exception.mode.FrameworkExceptionEnum;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class FrameworkErrorException
extends RuntimeException {
    private Integer errorCode;
    private String errorMessage;
    private String errorLocalizedMessage;

    public FrameworkErrorException() {
    }

    public FrameworkErrorException(Throwable cause) {
        super(null, cause);
        FrameworkExceptionEnum frameworkExceptionEnum = null;
        if (cause instanceof HttpMessageNotReadableException) {
            frameworkExceptionEnum = FrameworkExceptionEnum.HTTP_MESSAGE_NOT_READABLE;
        }
        if (!StringUtil.isNull((Object)((Object)frameworkExceptionEnum))) {
            this.errorLocalizedMessage = StringUtil.isNull((Object)cause) ? frameworkExceptionEnum.getErrorMessage() : ExceptionUtil.getErrorLocalizedMessage((Throwable)cause);
            this.errorMessage = frameworkExceptionEnum.getErrorMessage();
            this.errorCode = frameworkExceptionEnum.getErrorCode();
        }
    }

    public BaseResult formatException() {
        return this.formatException(null);
    }

    public BaseResult formatException(String requestId) {
        return BaseResult.error((BaseResultEnum)BaseResultEnum.SYSTEM_ERROR, (Object)new CommonExceptionVo(this.getErrorCode(), this.getErrorMessage(), requestId, null, this.getErrorLocalizedMessage()));
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorLocalizedMessage() {
        return this.errorLocalizedMessage;
    }
}

