/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.base;

import cn.chiship.sdk.cache.service.UserCacheService;
import cn.chiship.sdk.cache.vo.CacheOrganizationVo;
import cn.chiship.sdk.cache.vo.CacheRoleVo;
import cn.chiship.sdk.cache.vo.CacheUserVO;
import cn.chiship.sdk.core.annotation.Authorization;
import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.enums.BaseResultEnum;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.id.SnowflakeIdUtil;
import cn.chiship.sdk.core.util.DateUtils;
import cn.chiship.sdk.core.util.OutUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.base.BaseService;
import cn.chiship.sdk.framework.pojo.vo.OptionUser;
import cn.chiship.sdk.framework.pojo.vo.PageVo;
import cn.chiship.sdk.framework.util.BindingResultUtil;
import cn.chiship.sdk.framework.util.OptionUserUtil;
import cn.chiship.sdk.framework.util.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class BaseController<Record, Example> {
    @Autowired
    UserCacheService userCacheService;

    public abstract BaseService<Record, Example> getService();

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u5b57\u6bb5\u6821\u9a8c\u6570\u636e\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e", dataType="String", paramType="query"), @ApiImplicitParam(name="field", value="\u5b57\u6bb5", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="value", value="\u503c", required=true, dataType="String", paramType="query")})
    @Authorization
    @GetMapping(value={"validateExistByField"})
    public ResponseEntity<BaseResult> validateExistByField(@RequestParam(required=false, defaultValue="", value="id") String id, @RequestParam(value="field") String field, @RequestParam(value="value") String value) {
        return new ResponseEntity((Object)this.getService().validateExistByField(id, field, value), HttpStatus.OK);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u683c\u5f0f\u7684\u6570\u636e\u6587\u4ef6\uff0c\u652f\u6301\u5f02\u6b65\u5bfc\u51fa\uff0casync=true")
    @ApiImplicitParams(value={@ApiImplicitParam(name="paramsMap", value="\u6570\u636e\u96c6\u5408(\u5305\u542b\u5bfc\u51fa\u6587\u4ef6\u683c\u5f0f\u5b57\u6bb5\u3010exportType:csv\u3001xls\u3001xlsx.json\u3011\u53ca\u5bfc\u51fa\u6570\u636e\u7684\u6761\u4ef6)", required=true, dataType="JSONObject", paramType="body")})
    @PostMapping(value={"exportData"})
    public void exportData(@RequestBody JSONObject paramsMap, HttpServletResponse response) throws Exception {
        String a = "exportType";
        if (!paramsMap.containsKey((Object)a)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570[" + a + "]");
        }
        String exportType = paramsMap.get((Object)a).toString();
        if (StringUtil.isNullOrEmpty((String)exportType)) {
            BaseResult baseResult = BaseResult.error((Object)("\u53c2\u6570[" + a + "]\u4e0d\u80fd\u4e3a\u7a7a"));
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
        }
        boolean async = false;
        String b = "async";
        if (paramsMap.containsKey((Object)b)) {
            async = paramsMap.getBoolean(b);
        }
        if (async) {
            String taskId = DateUtils.dateTimeNow() + SnowflakeIdUtil.generateId();
            this.getService().asyncExportData(response, taskId, (Map<String, Object>)paramsMap);
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)BaseResult.ok((Object)taskId));
        } else {
            this.getService().exportData(response, (Map<String, Object>)paramsMap);
        }
    }

    @ApiOperation(value="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5f02\u6b65\u4efb\u52a1\u5b9e\u65f6\u8fdb\u5ea6(\u53ef\u5305\u88c5)")
    @ApiImplicitParams(value={})
    @PostMapping(value={"getProcessStatus"})
    public void getProcessStatus(HttpServletResponse response, @RequestBody Map<String, Object> paramsMap) throws Exception {
        String taskId = paramsMap.get("taskId").toString();
        if (StringUtil.isNullOrEmpty((String)taskId)) {
            BaseResult baseResult = BaseResult.error((BaseResultEnum)BaseResultEnum.FAILED, (Object)"\u7f3a\u5c11\u53c2\u6570[taskId]");
            OutUtil.writeJson((HttpServletResponse)response, (BaseResult)baseResult);
        }
        this.getService().getProcessStatus(response, taskId);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952eID", required=true, dataType="String", paramType="path")})
    @GetMapping(value={"getById/{id}"})
    public ResponseEntity<BaseResult> getById(@PathVariable(value="id") String id) {
        return new ResponseEntity((Object)BaseResult.ok(this.getService().selectByPrimaryKey(id)), HttpStatus.OK);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u8be6\u60c5\u6570\u636e(\u53ef\u5305\u88c5)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952eID", required=true, dataType="String", paramType="path")})
    @GetMapping(value={"getDetailsById/{id}"})
    public ResponseEntity<BaseResult> getDetailsById(@PathVariable(value="id") String id) {
        return new ResponseEntity((Object)this.getService().selectDetailsByPrimaryKey(id), HttpStatus.OK);
    }

    public PageVo page(Example example) {
        Integer pageSize;
        Integer pageIndex;
        PageVo pageVo = new PageVo();
        String sort = "-gmt_modified";
        try {
            pageIndex = ServletUtil.getParameterToInt("page");
            pageSize = ServletUtil.getParameterToInt("limit");
            sort = ServletUtil.getParameter("sort");
            if (pageIndex == null) {
                pageIndex = 1;
            }
            if (pageSize == null) {
                pageSize = 20;
            }
        }
        catch (Exception e) {
            pageIndex = 1;
            pageSize = 20;
        }
        pageVo.setCurrent(pageIndex.longValue());
        pageVo.setSize(pageSize.longValue());
        return this.getService().selectPageByExample(pageVo, example, sort);
    }

    public List<Record> list(Example example) {
        return this.getService().selectByExample(example);
    }

    public BaseResult save(Record record) {
        Class<?> clazz = record.getClass();
        try {
            Field createdBy = clazz.getDeclaredField("createdBy");
            createdBy.setAccessible(true);
            createdBy.set(record, OptionUserUtil.getCurrentOptionUser(this.getLoginUser()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getService().insertSelective(record);
    }

    public BaseResult update(Object id, Record record) {
        Class<?> clazz = record.getClass();
        try {
            if (StringUtil.isNull((Object)id)) {
                return BaseResult.error((BaseResultEnum)BaseResultEnum.BUSINESS_ERROR, (Object)"\u53c2\u6570[id]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Field idField = clazz.getDeclaredField("id");
            idField.setAccessible(true);
            idField.set(record, id);
            try {
                Field modifyBy = clazz.getDeclaredField("modifyBy");
                modifyBy.setAccessible(true);
                modifyBy.set(record, OptionUserUtil.getCurrentOptionUser(this.getLoginUser()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.getService().updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            throw new BusinessException(e.getLocalizedMessage());
        }
    }

    public BaseResult remove(Example example) {
        return this.getService().deleteByExample(example);
    }

    public BaseResult validParams(BindingResult bindingResult) {
        return BindingResultUtil.format(bindingResult);
    }

    protected Object getUserId() {
        return this.getLoginUser().getId();
    }

    protected String getUserName() {
        return this.getLoginUser().getUsername();
    }

    protected boolean hasRole(String role) {
        return this.hasRole(Collections.singletonList(role));
    }

    protected boolean hasRole(List<String> roles) {
        List<String> hasRoles = this.getRoles();
        return hasRoles.containsAll(roles);
    }

    protected Object getOrganizationId() {
        CacheOrganizationVo cacheOrganizationVo = this.getLoginUser().getCacheOrganizationVo();
        if (StringUtil.isNull((Object)cacheOrganizationVo)) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u7528\u6237\u6682\u65e0\u7ed1\u5b9a\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        return cacheOrganizationVo.getId();
    }

    protected List<String> getRoles() {
        List roleVos = this.getLoginUser().getCacheRoleVos();
        ArrayList<String> roles = new ArrayList<String>();
        if (roleVos != null) {
            for (CacheRoleVo roleVo : roleVos) {
                roles.add(roleVo.getRoleCode());
            }
        }
        return roles;
    }

    protected CacheUserVO getLoginUser() {
        CacheUserVO cacheUserVO = this.userCacheService.getUser();
        if (StringUtil.isNull((Object)cacheUserVO)) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u5f97\u5f53\u524d\u767b\u9646\u7528\u6237,\u8bf7\u53cd\u9988\u81f3\u7ba1\u7406\u5458");
        }
        return cacheUserVO;
    }

    protected String getCurrentOptionUser() {
        return OptionUserUtil.getCurrentOptionUser(this.getLoginUser());
    }

    protected OptionUser getCurrentOptionUser(String optionUserStr) {
        return OptionUserUtil.getCurrentOptionUser(optionUserStr);
    }

    protected ResponseEntity<BaseResult> responseEntity(BaseResult baseResult) {
        return this.responseEntity(baseResult, HttpStatus.OK);
    }

    protected ResponseEntity<BaseResult> responseEntity(BaseResult baseResult, HttpStatus httpStatus) {
        return new ResponseEntity((Object)baseResult, httpStatus);
    }
}

