/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.util;

import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.ip.IpUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextUtil
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext context = null;

    private SpringContextUtil() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static Object getBean(String beanName) {
        return context.getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> clazz) {
        return (T)context.getBean(beanName, clazz);
    }

    public static <T> T getBean(Class<T> clazz) {
        T t = null;
        Map map = context.getBeansOfType(clazz);
        for (Map.Entry entry : map.entrySet()) {
            t = (T)entry.getValue();
        }
        return t;
    }

    public static boolean containsBean(String beanName) {
        return context.containsBean(beanName);
    }

    public static boolean isSingleton(String beanName) {
        return context.isSingleton(beanName);
    }

    public static Class getType(String beanName) {
        return context.getType(beanName);
    }

    public static String getActiveProfile() {
        return context.getEnvironment().getActiveProfiles()[0];
    }

    public static void printRunningInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String javaVersion = System.getProperty("java.version");
        String ip = IpUtils.getHostIp();
        String port = context.getEnvironment().getProperty("server.port");
        String path = context.getEnvironment().getProperty("server.servlet.context-path");
        if (StringUtil.isEmpty((CharSequence)path)) {
            path = "";
        }
        LOGGER.info("\n\t----------------------------------------------------------\n\tApplication  is running! Access URLs:\n\tActiveProfile: \t\t" + SpringContextUtil.getActiveProfile() + "\n\tLocal\u8bbf\u95ee\u7f51\u5740: \t\thttp://localhost:" + port + path + "\n\tNetwork\u8bbf\u95ee\u7f51\u5740: \thttp://" + ip + ":" + port + path + "\n\tSwagger\u8bbf\u95ee\u7f51\u5740: \thttp://" + ip + ":" + port + path + "/doc.html\n\t----------------------------------------------------------\n\t\u64cd\u4f5c\u7cfb\u7edf\uff1a" + osName + "\uff08" + osVersion + "\uff09\t\t\u7cfb\u7edf\u67b6\u6784\uff1a" + osArch + "\t\tJAVA\u7248\u672c\uff1a" + javaVersion + "\n\t----------------------------------------------------------");
    }
}

