/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.ue.hunter;

import cn.chiship.sdk.core.util.FileUtil;
import cn.chiship.sdk.framework.ue.PathFormat;
import cn.chiship.sdk.framework.ue.define.BaseState;
import cn.chiship.sdk.framework.ue.define.MultiState;
import cn.chiship.sdk.framework.ue.define.State;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class FileManager {
    private String dir = null;
    private String rootPath = null;
    private String[] allowFiles = null;
    private int count = 0;

    public FileManager(Map<String, Object> conf) {
        this.rootPath = (String)conf.get("rootPath");
        this.dir = this.rootPath + (String)conf.get("dir");
        this.allowFiles = this.getAllowFiles(conf.get("allowFiles"));
        this.count = (Integer)conf.get("count");
    }

    public State listFile(int index) {
        File dir = new File(this.dir);
        State state = null;
        if (!dir.exists()) {
            return new BaseState(false, 302);
        }
        if (!dir.isDirectory()) {
            return new BaseState(false, 301);
        }
        Collection list = FileUtil.listFiles((File)dir, (String[])this.allowFiles, (boolean)true);
        if (index >= 0 && index <= list.size()) {
            Object[] fileList = Arrays.copyOfRange(list.toArray(), index, index + this.count);
            state = this.getState(fileList);
        } else {
            state = new MultiState(true);
        }
        state.putInfo("start", index);
        state.putInfo("total", list.size());
        return state;
    }

    private State getState(Object[] files) {
        Object obj;
        MultiState state = new MultiState(true);
        BaseState fileState = null;
        File file = null;
        Object[] var8 = files;
        int var7 = files.length;
        for (int var6 = 0; var6 < var7 && (obj = var8[var6]) != null; ++var6) {
            file = (File)obj;
            fileState = new BaseState(true);
            fileState.putInfo("url", PathFormat.format(this.getPath(file)));
            state.addState(fileState);
        }
        return state;
    }

    private String getPath(File file) {
        String path = file.getAbsolutePath();
        return path.replace(this.rootPath, "/");
    }

    private String[] getAllowFiles(Object fileExt) {
        String[] exts = null;
        String ext = null;
        if (fileExt == null) {
            return new String[0];
        }
        exts = (String[])fileExt;
        int len = exts.length;
        for (int i = 0; i < len; ++i) {
            ext = exts[i];
            exts[i] = ext.replace(".", "");
        }
        return exts;
    }
}

