/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.base;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.base.BaseResultEnum;
import cn.chiship.sdk.core.id.SnowflakeIdUtil;
import cn.chiship.sdk.core.util.CamelCaseUtils;
import cn.chiship.sdk.core.util.OutUtil;
import cn.chiship.sdk.core.util.RandomUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.base.BaseMapper;
import cn.chiship.sdk.framework.base.BaseService;
import cn.chiship.sdk.framework.pojo.vo.PageVo;
import cn.chiship.sdk.framework.properties.CommonConstantsConfigProperties;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseServiceImpl<Record, Example>
implements BaseService<Record, Example> {
    @Autowired
    private BaseMapper<Record, Example> baseMapper;

    @Override
    public BaseResult insertSelective(Record record) {
        try {
            boolean flag;
            Class<?> clazz = record.getClass();
            Field id = clazz.getDeclaredField("id");
            Field gmtCreated = clazz.getDeclaredField("gmtCreated");
            Field gmtModified = clazz.getDeclaredField("gmtModified");
            Field isDeleted = clazz.getDeclaredField("isDeleted");
            gmtCreated.setAccessible(true);
            gmtModified.setAccessible(true);
            isDeleted.setAccessible(true);
            id.setAccessible(true);
            if (StringUtil.isNull((Object)clazz.getMethod("getId", new Class[0]).invoke(record, new Object[0]))) {
                if ("Long".equals(id.getType().getSimpleName())) {
                    id.set(record, SnowflakeIdUtil.generateId());
                } else {
                    String tableKeyGenerator = CommonConstantsConfigProperties.getInstance().getTableKeyGenerator();
                    if ("UUID".equals(tableKeyGenerator)) {
                        id.set(record, RandomUtil.uuidLowerCase());
                    }
                    if ("SNOWFLAKE".equals(tableKeyGenerator)) {
                        id.set(record, SnowflakeIdUtil.generateStrId());
                    }
                }
            }
            gmtCreated.set(record, System.currentTimeMillis());
            gmtModified.set(record, System.currentTimeMillis());
            isDeleted.set(record, (byte)0);
            boolean bl = flag = this.baseMapper.insertSelective(record) > 0;
            if (!flag) {
                return new BaseResult(Boolean.FALSE, BaseResultEnum.EXCEPTION_DATA_BASE_INSERT, null);
            }
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public BaseResult deleteByExample(Example example) {
        try {
            this.baseMapper.deleteByExample(example);
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public BaseResult deleteByPrimaryKey(Object id) {
        try {
            this.baseMapper.deleteByPrimaryKey(id);
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public BaseResult updateByExampleSelective(Record record, Example example) {
        try {
            boolean flag;
            Class<?> clazz = record.getClass();
            Field gmtModified = clazz.getDeclaredField("gmtModified");
            gmtModified.setAccessible(true);
            gmtModified.set(record, System.currentTimeMillis());
            boolean bl = flag = this.baseMapper.updateByExampleSelective(record, example) > 0;
            if (!flag) {
                return new BaseResult(Boolean.FALSE, BaseResultEnum.EXCEPTION_DATA_BASE_UPDATE, null);
            }
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public BaseResult updateByPrimaryKeySelective(Record record) {
        try {
            boolean flag;
            Class<?> clazz = record.getClass();
            Field gmtModified = clazz.getDeclaredField("gmtModified");
            gmtModified.setAccessible(true);
            gmtModified.set(record, System.currentTimeMillis());
            boolean bl = flag = this.baseMapper.updateByPrimaryKeySelective(record) > 0;
            if (!flag) {
                return new BaseResult(Boolean.FALSE, BaseResultEnum.EXCEPTION_DATA_BASE_UPDATE, null);
            }
            return new BaseResult(Boolean.TRUE, BaseResultEnum.SUCCESS, record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public List<Record> selectByExample(Example example) {
        List<Record> records = this.baseMapper.selectByExample(example);
        return records;
    }

    @Override
    public Record selectByPrimaryKey(Object id) {
        Record record = this.baseMapper.selectByPrimaryKey(id);
        return record;
    }

    @Override
    public BaseResult selectDetailsByPrimaryKey(Object id) {
        return BaseResult.error((Object)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010selectDetailsByPrimaryKey\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e"));
    }

    @Override
    public long countByExample(Example example) {
        long count = this.baseMapper.countByExample(example);
        return count;
    }

    @Override
    public PageVo selectPageByExample(PageVo pageVo, Example example, String sort) {
        Page page = PageHelper.startPage((int)pageVo.getCurrent().intValue(), (int)pageVo.getSize().intValue());
        StringBuffer buffer = new StringBuffer();
        if (sort != null) {
            for (String s : sort.split(",")) {
                if ("+".equals(sort.substring(0, 1))) {
                    buffer.append(CamelCaseUtils.toUnderlineName((String)s.substring(1)) + " ASC");
                } else {
                    buffer.append(CamelCaseUtils.toUnderlineName((String)s.substring(1)) + " DESC");
                }
                buffer.append(",");
            }
        }
        if (buffer.length() > 0) {
            sort = buffer.substring(0, buffer.length() - 1);
        }
        PageHelper.orderBy((String)sort);
        List<Record> records = this.baseMapper.selectByExample(example);
        pageVo.setRecords(records);
        pageVo.setTotal(page.getTotal());
        pageVo.setPages(Long.valueOf(page.getPages()));
        return pageVo;
    }

    @Override
    public void exportData(HttpServletResponse response, Map<String, Object> paramMap) throws Exception {
        OutUtil.writeJSON((HttpServletResponse)response, (BaseResult)BaseResult.error((Object)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010exportData\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e")));
    }

    @Override
    public BaseResult validateExistByField(String id, String field, String value) {
        boolean flag = true;
        return BaseResult.error((Object)("\u8bf7\u5728\u3010" + this.getClass().getSimpleName() + "\u3011\u7c7b\u4e2d\u5bf9\u65b9\u6cd5\u3010validateExistByField\u3011\u91cd\u5199,\u8fdb\u884c\u4e1a\u52a1\u914d\u7f6e"));
    }
}

