/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.framework.base;

import cn.chiship.sdk.core.annotation.Authorization;
import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.base.BaseResultEnum;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.util.OutUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.framework.base.BaseService;
import cn.chiship.sdk.framework.pojo.vo.PageVo;
import cn.chiship.sdk.framework.util.BindingResultUtil;
import cn.chiship.sdk.framework.util.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class BaseController<Record, Example> {
    public abstract BaseService<Record, Example> getService();

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u5b57\u6bb5\u6821\u9a8c\u6570\u636e\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e", defaultValue="", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="field", value="\u5b57\u6bb5", defaultValue="", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="value", value="\u503c", defaultValue="", required=true, dataType="String", paramType="query")})
    @Authorization
    @GetMapping(value={"validateExistByField"})
    public ResponseEntity<BaseResult> validateExistByField(@RequestParam(required=false, defaultValue="", value="id") String id, @RequestParam(value="field") String field, @RequestParam(value="value") String value) {
        return new ResponseEntity((Object)this.getService().validateExistByField(id, field, value), HttpStatus.OK);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u683c\u5f0f\u7684\u6570\u636e\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="paramsMap", value="\u6570\u636e\u96c6\u5408(\u5305\u542b\u5bfc\u51fa\u6587\u4ef6\u683c\u5f0f\u5b57\u6bb5\u3010exportType:csv\u3001xls\u3001xlsx.json\u3011\u53ca\u5bfc\u51fa\u6570\u636e\u7684\u6761\u4ef6)", required=true, dataType="JSONObject", paramType="body")})
    @PostMapping(value={"exportData"})
    public void exportData(@RequestBody(required=true) JSONObject paramsMap, HttpServletResponse response) throws Exception {
        if (!paramsMap.containsKey((Object)"exportType")) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570[exportType]");
        }
        String exportType = paramsMap.get((Object)"exportType").toString();
        if (StringUtil.isNullOrEmpty((String)exportType)) {
            BaseResult baseResult = BaseResult.error((Object)"\u53c2\u6570[exportType]\u4e0d\u80fd\u4e3a\u7a7a");
            OutUtil.writeJSON((HttpServletResponse)response, (BaseResult)baseResult);
        }
        this.getService().exportData(response, (Map<String, Object>)paramsMap);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952eID", required=true, dataType="String", paramType="path")})
    @GetMapping(value={"getById/{id}"})
    public ResponseEntity<BaseResult> getById(@PathVariable(value="id") String id) {
        return new ResponseEntity((Object)BaseResult.ok(this.getService().selectByPrimaryKey(id)), HttpStatus.OK);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u8be6\u60c5\u6570\u636e(\u53ef\u5305\u88c5)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952eID", required=true, dataType="String", paramType="path")})
    @GetMapping(value={"getDetailsById/{id}"})
    public ResponseEntity<BaseResult> getDetailsById(@PathVariable(value="id") String id) {
        return new ResponseEntity((Object)this.getService().selectDetailsByPrimaryKey(id), HttpStatus.OK);
    }

    public PageVo page(Example example) {
        Integer pageSize;
        Integer pageIndex;
        PageVo pageVo = new PageVo();
        String sort = "-gmt_modified";
        try {
            pageIndex = ServletUtil.getParameterToInt("page");
            pageSize = ServletUtil.getParameterToInt("limit");
            sort = ServletUtil.getParameter("sort");
            if (pageIndex == null) {
                pageIndex = 1;
            }
            if (pageSize == null) {
                pageSize = 20;
            }
        }
        catch (Exception e) {
            pageIndex = 1;
            pageSize = 20;
        }
        pageVo.setCurrent(pageIndex.longValue());
        pageVo.setSize(pageSize.longValue());
        return this.getService().selectPageByExample(pageVo, example, sort);
    }

    public BaseResult save(Record record) {
        return this.getService().insertSelective(record);
    }

    public BaseResult update(Object id, Record record) {
        Class<?> clazz = record.getClass();
        try {
            if (StringUtil.isNull((Object)id)) {
                return BaseResult.error((BaseResultEnum)BaseResultEnum.BUSINESS_ERROR, (Object)"\u53c2\u6570[id]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Field idField = clazz.getDeclaredField("id");
            idField.setAccessible(true);
            idField.set(record, id);
            return this.getService().updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public BaseResult remove(Example example) {
        return this.getService().deleteByExample(example);
    }

    public BaseResult validParams(BindingResult bindingResult) {
        return BindingResultUtil.format(bindingResult);
    }
}

